/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import fr.frinn.custommachinery.api.crafting.IRecipeBuilder;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.IChanceableRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

public abstract class AbstractRecipeJSBuilder<T extends IRecipeBuilder<? extends class_1860<?>>>
extends RecipeJS
implements RecipeJSBuilder {
    private static final Map<class_2960, Map<class_2960, Integer>> IDS = new HashMap<class_2960, Map<class_2960, Integer>>();
    private final class_2960 id;
    private final Codec<T> builderCodec;
    private T builder;
    private class_2960 machine;
    private IRequirement<?> lastRequirement;
    private boolean jei = false;

    public AbstractRecipeJSBuilder(class_2960 id, Codec<T> builderCodec) {
        this.id = id;
        this.builderCodec = builderCodec;
    }

    public abstract T makeBuilder(class_2960 var1, List<Object> var2);

    public T builder() {
        return this.builder;
    }

    public void create(ListJS args) {
        if (args.size() < 1 || !(args.get(0) instanceof String) || !Utils.isResourceNameValid((String)args.get(0))) {
            throw new RecipeExceptionJS("Custom Machine recipe must have a machine id specified as first argument");
        }
        this.machine = new class_2960((String)args.remove(0));
        this.builder = this.makeBuilder(this.machine, (List<Object>)args);
        int uniqueID = IDS.computeIfAbsent(this.id, id -> new HashMap()).computeIfAbsent(this.machine, m -> 0);
        IDS.get(this.id).put(this.machine, uniqueID + 1);
        this.id(new class_2960("kubejs", this.id.method_12832() + "/" + this.machine.method_12836() + "/" + this.machine.method_12832() + "/" + uniqueID));
    }

    public class_1860<?> createRecipe() {
        return (class_1860)this.builder.build(this.getOrCreateId());
    }

    public void deserialize() {
        DataResult result = this.builderCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)this.json);
        this.builder = (IRecipeBuilder)result.resultOrPartial(arg_0 -> ((ConsoleJS)ScriptType.SERVER.console).error(arg_0)).orElseThrow(() -> new RecipeExceptionJS("Invalid Custom Machine Recipe"));
    }

    public void serialize() {
        DataResult result = this.builderCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.builder);
        this.json = (JsonObject)result.resultOrPartial(arg_0 -> ((ConsoleJS)ScriptType.SERVER.console).error(arg_0)).orElseThrow(() -> new RecipeExceptionJS("Invalid Custom Machine Recipe"));
    }

    public String getFromToString() {
        return this.builder.toString();
    }

    public RecipeJS merge(Object data) {
        ScriptType.SERVER.console.warn((Object)"Don't use 'merge' method on custom machine recipe");
        return this;
    }

    public AbstractRecipeJSBuilder<T> jei() {
        this.jei = true;
        return this;
    }

    public AbstractRecipeJSBuilder<T> priority(int priority) {
        if (!this.jei) {
            this.builder.withPriority(priority);
        } else {
            this.builder.withJeiPriority(priority);
        }
        return this;
    }

    public AbstractRecipeJSBuilder<T> chance(double chance) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IChanceableRequirement) {
            ((IChanceableRequirement)this.lastRequirement).setChance(chance);
        } else {
            ScriptType.SERVER.console.warn((Object)("Can't set chance for requirement: " + this.lastRequirement));
        }
        return this;
    }

    public AbstractRecipeJSBuilder<T> hide() {
        return this;
    }

    public AbstractRecipeJSBuilder<T> delay(double delay) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IDelayedRequirement) {
            ((IDelayedRequirement)this.lastRequirement).setDelay(delay);
        } else {
            ScriptType.SERVER.console.warn((Object)("Can't set delay for requirement: " + this.lastRequirement));
        }
        return this;
    }

    @Override
    public AbstractRecipeJSBuilder<T> addRequirement(IRequirement<?> requirement) {
        this.lastRequirement = requirement;
        if (!this.jei) {
            this.builder().withRequirement(requirement);
        } else {
            this.builder().withJeiRequirement(requirement);
        }
        return this;
    }
}

