/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.common.collect.ImmutableList;
import dev.latvian.mods.kubejs.event.EventJS;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class CustomMachineUpgradeJSBuilder {
    private final class_1792 item;
    private List<class_2561> tooltips;
    private final List<class_2960> machines;
    private final List<RecipeModifier> modifiers;
    private final int maxAmount;

    public CustomMachineUpgradeJSBuilder(class_1792 item, int maxAmount) {
        this.item = item;
        this.tooltips = Collections.singletonList(new class_2588("custommachinery.upgrade.tooltip").method_27692(class_124.field_1075));
        this.maxAmount = maxAmount;
        this.machines = new ArrayList<class_2960>();
        this.modifiers = new ArrayList<RecipeModifier>();
    }

    public MachineUpgrade build() {
        if (this.machines.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 machine for machine upgrade item: " + class_2378.field_11142.method_10221((Object)this.item));
        }
        if (this.modifiers.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 recipe modifier for machine upgrade item: " + class_2378.field_11142.method_10221((Object)this.item));
        }
        return new MachineUpgrade(this.item, this.machines, this.modifiers, this.tooltips, this.maxAmount);
    }

    public CustomMachineUpgradeJSBuilder machine(String ... string) {
        for (String s : string) {
            class_2960 machine;
            try {
                machine = new class_2960(s);
            }
            catch (class_151 e) {
                throw new IllegalArgumentException("Invalid Machine ID: " + s + "\n" + e.getMessage());
            }
            this.machines.add(machine);
        }
        return this;
    }

    public CustomMachineUpgradeJSBuilder tooltip(class_2561 ... components) {
        this.tooltips = ImmutableList.copyOf((Object[])components);
        return this;
    }

    public CustomMachineUpgradeJSBuilder modifier(JSRecipeModifierBuilder builder) {
        this.modifiers.add(builder.build());
        return this;
    }

    public static class JSRecipeModifierBuilder {
        private final RequirementType<?> requirementType;
        private final RequirementIOMode mode;
        private final IRecipeModifier.OPERATION operation;
        private final double modifier;
        private String target = "";
        private double chance = 1.0;
        private double max = Double.POSITIVE_INFINITY;
        private double min = Double.NEGATIVE_INFINITY;
        private class_2561 tooltip = null;

        private JSRecipeModifierBuilder(RequirementType<?> type, RequirementIOMode mode, IRecipeModifier.OPERATION operation, double modifier) {
            this.requirementType = type;
            this.mode = mode;
            this.operation = operation;
            this.modifier = modifier;
        }

        private static RequirementType<?> getType(class_2960 id) {
            RequirementType type = (RequirementType)((Object)Registration.REQUIREMENT_TYPE_REGISTRY.get(id));
            if (type != null) {
                return type;
            }
            throw new IllegalArgumentException("Invalid requirement type: " + id);
        }

        public static JSRecipeModifierBuilder addInput(class_2960 type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        public static JSRecipeModifierBuilder mulInput(class_2960 type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        public static JSRecipeModifierBuilder addOutput(class_2960 type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        public static JSRecipeModifierBuilder mulOutput(class_2960 type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        public JSRecipeModifierBuilder target(String target) {
            this.target = target;
            return this;
        }

        public JSRecipeModifierBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        public JSRecipeModifierBuilder max(double max) {
            this.max = max;
            return this;
        }

        public JSRecipeModifierBuilder min(double min) {
            this.min = min;
            return this;
        }

        public JSRecipeModifierBuilder tooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        private RecipeModifier build() {
            return new RecipeModifier(this.requirementType, this.mode, this.operation, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
        }
    }

    public static class UpgradeEvent
    extends EventJS {
        private final List<CustomMachineUpgradeJSBuilder> builders = new ArrayList<CustomMachineUpgradeJSBuilder>();

        public CustomMachineUpgradeJSBuilder create(class_1792 item) {
            CustomMachineUpgradeJSBuilder builder = new CustomMachineUpgradeJSBuilder(item, 64);
            this.builders.add(builder);
            return builder;
        }

        public CustomMachineUpgradeJSBuilder create(class_1792 item, int maxAmount) {
            CustomMachineUpgradeJSBuilder builder = new CustomMachineUpgradeJSBuilder(item, maxAmount);
            this.builders.add(builder);
            return builder;
        }

        public List<CustomMachineUpgradeJSBuilder> getBuilders() {
            return this.builders;
        }
    }
}

