/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.util.MapJS;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.requirement.DurabilityRequirement;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;

public interface DurabilityRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder damageItem(ItemStackJS stack, int amount) {
        return this.damageItem(stack, amount, "");
    }

    default public RecipeJSBuilder damageItem(ItemStackJS stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.getItem()), amount, KubeJSIntegration.nbtFromStack(stack), true, slot));
    }

    default public RecipeJSBuilder damageItemNoBreak(ItemStackJS stack, int amount) {
        return this.damageItem(stack, amount, "");
    }

    default public RecipeJSBuilder damageItemNoBreak(ItemStackJS stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.getItem()), amount, KubeJSIntegration.nbtFromStack(stack), false, slot));
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount) {
        return this.damageItemTag(tag, amount, null, "");
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.damageItemTag(tag, amount, null, (String)thing);
        }
        return this.damageItemTag(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount, MapJS nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : nbt.toNBT(), true, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount) {
        return this.damageItemTagNoBreak(tag, amount, null, "");
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.damageItemTagNoBreak(tag, amount, null, (String)thing);
        }
        return this.damageItemTagNoBreak(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount, MapJS nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : nbt.toNBT(), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    default public RecipeJSBuilder repairItem(ItemStackJS stack, int amount) {
        return this.repairItem(stack, amount, "");
    }

    default public RecipeJSBuilder repairItem(ItemStackJS stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, new ItemIngredient(stack.getItem()), amount, KubeJSIntegration.nbtFromStack(stack), false, slot));
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount) {
        return this.repairItemTag(tag, amount, null, "");
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.repairItemTag(tag, amount, null, (String)thing);
        }
        return this.repairItemTag(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount, MapJS nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : nbt.toNBT(), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }
}

