/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.EntityRequirement;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public interface EntityRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requireEntities(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty() || !whitelist) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CHECK_AMOUNT, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"requireEntities\" in whitelist mode with an empty filter", new Object[0]);
    }

    default public RecipeJSBuilder requireEntitiesHealth(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty()) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CHECK_HEALTH, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"requireEntitiesHealth\" in whitelist mode with an empty filter", new Object[0]);
    }

    default public RecipeJSBuilder consumeEntityHealthOnStart(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty()) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CONSUME_HEALTH, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"consumeEntityHealthOnStart\" in whitelist mode with an empty filter", new Object[0]);
    }

    default public RecipeJSBuilder consumeEntityHealthOnEnd(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty()) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.OUTPUT, EntityRequirement.ACTION.CONSUME_HEALTH, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"consumeEntityHealthOnEnd\" in whitelist mode with an empty filter", new Object[0]);
    }

    default public RecipeJSBuilder killEntitiesOnStart(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty()) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.KILL, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"killEntitiesOnStart\" in whitelist mode with an empty filter", new Object[0]);
    }

    default public RecipeJSBuilder killEntitiesOnEnd(int amount, int radius, String[] filter, boolean whitelist) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !class_2378.field_11145.method_10250(new class_2960(type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((class_1299)class_2378.field_11145.method_10223(new class_2960(type)));
        }
        if (!entityFilter.isEmpty()) {
            return this.addRequirement(new EntityRequirement(RequirementIOMode.OUTPUT, EntityRequirement.ACTION.KILL, amount, radius, entityFilter, whitelist));
        }
        return this.error("Can't use \"killEntitiesOnEnd\" in whitelist mode with an empty filter", new Object[0]);
    }
}

