/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.machine.MachineAppearanceManager;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.TextComponentUtils;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;

public class CustomMachine
implements ICustomMachine {
    public static final Codec<CustomMachine> CODEC = RecordCodecBuilder.create(machineCodec -> machineCodec.group((App)TextComponentUtils.CODEC.fieldOf("name").forGetter(machine -> machine.name), (App)MachineAppearanceManager.CODEC.fieldOf("appearance").forGetter(machine -> machine.appearance), (App)CodecLogger.loggedOptional(Codecs.list(TextComponentUtils.CODEC), "tooltips", Collections.emptyList()).forGetter(CustomMachine::getTooltips), (App)CodecLogger.loggedOptional(Codecs.list(IGuiElement.CODEC), "gui", Collections.emptyList()).forGetter(CustomMachine::getGuiElements), (App)CodecLogger.loggedOptional(Codecs.list(IGuiElement.CODEC), "jei", Collections.emptyList()).forGetter(CustomMachine::getJeiElements), (App)CodecLogger.loggedOptional(Codecs.list(class_2960.field_25139), "catalysts", Collections.emptyList()).forGetter(CustomMachine::getCatalysts), (App)CodecLogger.loggedOptional(Codecs.list(IMachineComponentTemplate.CODEC), "components", Collections.emptyList()).forGetter(CustomMachine::getComponentTemplates), (App)CodecLogger.loggedOptional(IProcessorTemplate.CODEC, "processor", MachineProcessor.Template.DEFAULT).forGetter(CustomMachine::getProcessorTemplate)).apply((Applicative)machineCodec, CustomMachine::new));
    public static final CustomMachine DUMMY = new CustomMachineBuilder().setName((class_2561)new class_2585("Dummy")).setLocation(MachineLocation.fromDefault(new class_2960("custommachinery", "dummy"))).build();
    private final class_2561 name;
    private final MachineAppearanceManager appearance;
    private final List<class_2561> tooltips;
    private final List<IGuiElement> guiElements;
    private final List<IGuiElement> jeiElements;
    private final List<class_2960> catalysts;
    private final List<IMachineComponentTemplate<? extends IMachineComponent>> componentTemplates;
    private final IProcessorTemplate<? extends IProcessor> processorTemplate;
    private MachineLocation location;

    public CustomMachine(class_2561 name, MachineAppearanceManager appearance, List<class_2561> tooltips, List<IGuiElement> guiElements, List<IGuiElement> jeiElements, List<class_2960> catalysts, List<IMachineComponentTemplate<? extends IMachineComponent>> componentTemplates, IProcessorTemplate<? extends IProcessor> processorTemplate) {
        this.name = name;
        this.appearance = appearance;
        this.tooltips = tooltips;
        this.guiElements = guiElements;
        this.jeiElements = jeiElements;
        this.catalysts = catalysts;
        this.componentTemplates = componentTemplates;
        this.processorTemplate = processorTemplate;
    }

    @Override
    public class_2960 getId() {
        return this.location.getId();
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public boolean isDummy() {
        return this == DUMMY;
    }

    @Override
    public MachineAppearance getAppearance(MachineStatus status) {
        return this.appearance.getAppearance(status);
    }

    public IProcessorTemplate<? extends IProcessor> getProcessorTemplate() {
        return this.processorTemplate;
    }

    public List<class_2561> getTooltips() {
        return this.tooltips;
    }

    public List<IGuiElement> getGuiElements() {
        return this.guiElements;
    }

    public List<IGuiElement> getJeiElements() {
        return this.jeiElements;
    }

    public List<class_2960> getCatalysts() {
        return this.catalysts;
    }

    public List<IMachineComponentTemplate<? extends IMachineComponent>> getComponentTemplates() {
        return this.componentTemplates;
    }

    public CustomMachine setLocation(MachineLocation location) {
        this.location = location;
        return this;
    }

    public MachineLocation getLocation() {
        return this.location;
    }
}

