/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.MachineShape;
import fr.frinn.custommachinery.impl.util.ModelLocation;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3414;
import net.minecraft.class_6862;

public class MachineAppearance
implements IMachineAppearance {
    public static final MapCodec<Map<MachineAppearanceProperty<?>, Object>> CODEC = new MapCodec<Map<MachineAppearanceProperty<?>, Object>>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Registration.APPEARANCE_PROPERTY_REGISTRY.getIds().stream().map(loc -> ops.createString(loc.toString()));
        }

        public <T> DataResult<Map<MachineAppearanceProperty<?>, Object>> decode(DynamicOps<T> ops, MapLike<T> input) {
            ImmutableMap.Builder properties = ImmutableMap.builder();
            for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
                DataResult result;
                if (property.getId() != null && input.get(property.getId().toString()) != null) {
                    result = property.getCodec().parse(ops, input.get(property.getId().toString()));
                    if (result.result().isPresent()) {
                        properties.put((Object)property, result.result().get());
                        continue;
                    }
                    if (!result.error().isPresent()) continue;
                    ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't deserialize appearance property: {}, invalid value: {}, error: {}, using default value instead.", (Object)property.getId(), input.get(property.getId().toString()), (Object)((DataResult.PartialResult)result.error().get()).message());
                    properties.put((Object)property, property.getDefaultValue());
                    continue;
                }
                if (property.getId() != null && input.get(property.getId().method_12832()) != null) {
                    result = property.getCodec().parse(ops, input.get(property.getId().method_12832()));
                    if (result.result().isPresent()) {
                        properties.put((Object)property, result.result().get());
                        continue;
                    }
                    if (!result.error().isPresent()) continue;
                    ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't deserialize appearance property: {}, invalid value: {}, error: {}, using default value instead.", (Object)property.getId(), input.get(property.getId().method_12832()), (Object)((DataResult.PartialResult)result.error().get()).message());
                    properties.put((Object)property, property.getDefaultValue());
                    continue;
                }
                properties.put((Object)property, property.getDefaultValue());
            }
            return DataResult.success((Object)properties.build());
        }

        public <T> RecordBuilder<T> encode(Map<MachineAppearanceProperty<?>, Object> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            for (Map.Entry<MachineAppearanceProperty<?>, Object> entry : input.entrySet()) {
                if (entry.getValue() == entry.getKey().getDefaultValue() || entry.getKey().getId() == null) continue;
                prefix.add(entry.getKey().getId().toString(), entry.getKey().getCodec().encodeStart(ops, entry.getValue()));
            }
            return prefix;
        }

        public String toString() {
            return "Machine Appearance";
        }
    };
    private final Map<MachineAppearanceProperty<?>, Object> properties;

    public MachineAppearance(Map<MachineAppearanceProperty<?>, Object> properties) {
        this.properties = properties;
    }

    @Override
    public <T> T getProperty(MachineAppearanceProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalStateException("Can't get Machine Appearance property for: " + property.getId() + ", this property may not be registered");
        }
        return (T)this.properties.get(property);
    }

    @Override
    public ModelLocation getBlockModel() {
        return (ModelLocation)this.getProperty((MachineAppearanceProperty)((Object)Registration.BLOCK_MODEL_PROPERTY.get()));
    }

    @Override
    public ModelLocation getItemModel() {
        return (ModelLocation)this.getProperty((MachineAppearanceProperty)((Object)Registration.ITEM_MODEL_PROPERTY.get()));
    }

    @Override
    public class_3414 getAmbientSound() {
        return (class_3414)this.getProperty((MachineAppearanceProperty)((Object)Registration.AMBIENT_SOUND_PROPERTY.get()));
    }

    @Override
    public class_2498 getInteractionSound() {
        return (class_2498)this.getProperty((MachineAppearanceProperty)((Object)Registration.INTERACTION_SOUND_PROPERTY.get()));
    }

    @Override
    public int getLightLevel() {
        return (Integer)this.getProperty((MachineAppearanceProperty)((Object)Registration.LIGHT_PROPERTY.get()));
    }

    @Override
    public int getColor() {
        return (Integer)this.getProperty((MachineAppearanceProperty)((Object)Registration.COLOR_PROPERTY.get()));
    }

    @Override
    public float getHardness() {
        return ((Float)this.getProperty((MachineAppearanceProperty)((Object)Registration.HARDNESS_PROPERTY.get()))).floatValue();
    }

    @Override
    public float getResistance() {
        return ((Float)this.getProperty((MachineAppearanceProperty)((Object)Registration.RESISTANCE_PROPERTY.get()))).floatValue();
    }

    @Override
    public List<class_6862<class_2248>> getTool() {
        return (List)this.getProperty((MachineAppearanceProperty)((Object)Registration.TOOL_TYPE_PROPERTY.get()));
    }

    @Override
    public class_6862<class_2248> getMiningLevel() {
        return (class_6862)this.getProperty((MachineAppearanceProperty)((Object)Registration.MINING_LEVEL_PROPERTY.get()));
    }

    @Override
    public boolean requiresCorrectToolForDrops() {
        return (Boolean)this.getProperty((MachineAppearanceProperty)((Object)Registration.REQUIRES_TOOL.get()));
    }

    public MachineShape getShape() {
        return (MachineShape)this.getProperty((MachineAppearanceProperty)((Object)Registration.SHAPE_PROPERTY.get()));
    }

    @Override
    public MachineAppearance copy() {
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)ImmutableMap.copyOf(this.properties));
    }

    public Map<MachineAppearanceProperty<?>, Object> getProperties() {
        return this.properties;
    }
}

