/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import java.util.Map;

public class MachineAppearanceManager {
    public static final Codec<MachineAppearanceManager> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)MachineAppearance.CODEC.forGetter(manager -> manager.defaultProperties), (App)MachineAppearance.CODEC.fieldOf("idle").orElse((Object)Maps.newHashMap()).forGetter(manager -> manager.idle.getProperties()), (App)MachineAppearance.CODEC.fieldOf("running").orElse((Object)Maps.newHashMap()).forGetter(manager -> manager.running.getProperties()), (App)MachineAppearance.CODEC.fieldOf("errored").orElse((Object)Maps.newHashMap()).forGetter(manager -> manager.errored.getProperties()), (App)MachineAppearance.CODEC.fieldOf("paused").orElse((Object)Maps.newHashMap()).forGetter(manager -> manager.paused.getProperties())).apply((Applicative)builder, (defaults, idle, running, errored, paused) -> {
        MachineAppearance idleAppearance = MachineAppearanceManager.buildAppearance(defaults, idle);
        MachineAppearance runningAppearance = MachineAppearanceManager.buildAppearance(defaults, running);
        MachineAppearance erroredAppearance = MachineAppearanceManager.buildAppearance(defaults, errored);
        MachineAppearance pausedAppearance = MachineAppearanceManager.buildAppearance(defaults, paused);
        return new MachineAppearanceManager((Map<MachineAppearanceProperty<?>, Object>)defaults, idleAppearance, runningAppearance, erroredAppearance, pausedAppearance);
    }));
    private final Map<MachineAppearanceProperty<?>, Object> defaultProperties;
    private final MachineAppearance idle;
    private final MachineAppearance running;
    private final MachineAppearance errored;
    private final MachineAppearance paused;

    public MachineAppearanceManager(Map<MachineAppearanceProperty<?>, Object> defaultProperties, MachineAppearance idle, MachineAppearance running, MachineAppearance errored, MachineAppearance paused) {
        this.defaultProperties = defaultProperties;
        this.idle = idle;
        this.running = running;
        this.errored = errored;
        this.paused = paused;
    }

    public MachineAppearance getAppearance(MachineStatus status) {
        switch (status) {
            case IDLE: {
                return this.idle;
            }
            case RUNNING: {
                return this.running;
            }
            case ERRORED: {
                return this.errored;
            }
            case PAUSED: {
                return this.paused;
            }
        }
        throw new IllegalArgumentException("Invalid machine status: " + status);
    }

    private static MachineAppearance buildAppearance(Map<MachineAppearanceProperty<?>, Object> defaults, Map<MachineAppearanceProperty<?>, Object> specifics) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
            Object value = specifics.get((Object)property);
            if (value == null || value == property.getDefaultValue()) {
                properties.put((Object)property, defaults.get((Object)property));
                continue;
            }
            properties.put((Object)property, value);
        }
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)properties.build());
    }
}

