/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.common.util.Codecs;
import java.io.File;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class MachineLocation {
    public static final Codec<MachineLocation> CODEC = RecordCodecBuilder.create(machineLocationInstance -> machineLocationInstance.group((App)class_2960.field_25139.fieldOf("id").forGetter(MachineLocation::getId), (App)Codecs.LOADER_CODEC.fieldOf("loader").forGetter(MachineLocation::getLoader), (App)Codec.STRING.fieldOf("packName").forGetter(MachineLocation::getPackName)).apply((Applicative)machineLocationInstance, MachineLocation::new));
    private class_2960 id;
    private Loader loader;
    private String packName;

    private MachineLocation(class_2960 id, Loader loader, String packName) {
        this.id = id;
        this.loader = loader;
        this.packName = packName;
    }

    public static MachineLocation fromLoader(Loader loader, class_2960 id, String packName) {
        switch (loader) {
            case DEFAULT: {
                return MachineLocation.fromDefault(id);
            }
            case DATAPACK: {
                return MachineLocation.fromDatapack(id, packName);
            }
            case CRAFTTWEAKER: {
                return MachineLocation.fromCraftTweaker(id);
            }
            case KUBEJS: {
                return MachineLocation.fromKubeJS(id);
            }
        }
        throw new IllegalStateException("Invalid Custom Machine Loader: " + loader.name());
    }

    public static MachineLocation fromDefault(class_2960 id) {
        return new MachineLocation(id, Loader.DEFAULT, "");
    }

    public static MachineLocation fromDatapack(class_2960 id, String packName) {
        return new MachineLocation(id, Loader.DATAPACK, packName);
    }

    public static MachineLocation fromCraftTweaker(class_2960 id) {
        return new MachineLocation(id, Loader.CRAFTTWEAKER, "");
    }

    public static MachineLocation fromKubeJS(class_2960 id) {
        return new MachineLocation(id, Loader.KUBEJS, "");
    }

    public class_2960 getId() {
        return this.id;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getPath() {
        return this.packName + File.separator + "data" + File.separator + this.id.method_12836() + File.separator + "machines" + File.separator + this.id.method_12832() + ".json";
    }

    public static enum Loader {
        DEFAULT,
        DATAPACK,
        CRAFTTWEAKER,
        KUBEJS;


        public class_2588 getTranslatedName() {
            return new class_2588("custommachinery.machine.loader." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public int getColor() {
            switch (this) {
                case DEFAULT: {
                    return class_124.field_1074.method_532();
                }
                case DATAPACK: {
                    return class_124.field_1077.method_532();
                }
                case KUBEJS: {
                    return class_124.field_1064.method_532();
                }
                case CRAFTTWEAKER: {
                    return class_124.field_1062.method_532();
                }
            }
            return 0;
        }

        public static Loader value(String value) {
            return Loader.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

