/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.builder.IMachineComponentBuilder;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearanceManager;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.MachineAppearanceBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;

public class CustomMachineBuilder {
    private class_2561 name;
    private final Map<MachineStatus, MachineAppearanceBuilder> appearance;
    private final List<class_2561> tooltips;
    private final List<IGuiElement> guiElements;
    private final List<IGuiElement> jeiElements;
    private final List<class_2960> catalysts;
    private final List<IMachineComponentBuilder<? extends IMachineComponent>> componentBuilders;
    private MachineLocation location;

    public CustomMachineBuilder() {
        this.name = new class_2585("New Machine");
        this.appearance = Arrays.stream(MachineStatus.values()).collect(Collectors.toMap(Function.identity(), status -> new MachineAppearanceBuilder()));
        this.tooltips = new ArrayList<class_2561>();
        this.guiElements = new ArrayList<IGuiElement>();
        this.jeiElements = new ArrayList<IGuiElement>();
        this.catalysts = new ArrayList<class_2960>();
        this.componentBuilders = new ArrayList<IMachineComponentBuilder<? extends IMachineComponent>>();
        this.location = MachineLocation.fromDefault(new class_2960("custommachinery", "new_machine"));
    }

    public CustomMachineBuilder(CustomMachine machine) {
        this.name = machine.getName();
        this.appearance = Arrays.stream(MachineStatus.values()).collect(Collectors.toMap(Function.identity(), status -> new MachineAppearanceBuilder(machine.getAppearance((MachineStatus)((Object)status)))));
        this.tooltips = machine.getTooltips();
        this.guiElements = machine.getGuiElements();
        this.jeiElements = machine.getJeiElements();
        this.catalysts = machine.getCatalysts();
        this.componentBuilders = new ArrayList<IMachineComponentBuilder<? extends IMachineComponent>>();
        machine.getComponentTemplates().forEach(template -> {
            if (template.getType().haveGUIBuilder()) {
                this.componentBuilders.add(template.getType().getGUIBuilder().get().fromComponent((IMachineComponent)template.build(null)));
            }
        });
        this.location = machine.getLocation();
    }

    public class_2561 getName() {
        return this.name;
    }

    public CustomMachineBuilder setName(class_2561 name) {
        this.name = name;
        return this;
    }

    public CustomMachineBuilder withAppearance(MachineStatus status, MachineAppearanceBuilder builder) {
        this.appearance.put(status, builder);
        return this;
    }

    public MachineAppearanceBuilder getAppearance(MachineStatus status) {
        return this.appearance.get((Object)status);
    }

    public CustomMachineBuilder withGuiElement(IGuiElement element) {
        this.guiElements.add(element);
        return this;
    }

    public List<IGuiElement> getGuiElements() {
        return this.guiElements;
    }

    public List<IMachineComponentBuilder<? extends IMachineComponent>> getComponentBuilders() {
        return this.componentBuilders;
    }

    public MachineLocation getLocation() {
        return this.location;
    }

    public CustomMachineBuilder setLocation(MachineLocation location) {
        this.location = location;
        return this;
    }

    public CustomMachineBuilder setId(class_2960 id) {
        MachineLocation.Loader loader = this.location.getLoader();
        String packName = this.location.getPackName();
        this.location = MachineLocation.fromLoader(loader, id, packName);
        return this;
    }

    public CustomMachine build() {
        class_2585 name = this.name == null ? new class_2585("New Machine") : this.name;
        MachineAppearanceManager appearance = new MachineAppearanceManager(Maps.newHashMap(), this.appearance.get((Object)MachineStatus.IDLE).build(), this.appearance.get((Object)MachineStatus.RUNNING).build(), this.appearance.get((Object)MachineStatus.ERRORED).build(), this.appearance.get((Object)MachineStatus.PAUSED).build());
        ImmutableList tooltips = this.tooltips == null ? ImmutableList.of() : ImmutableList.copyOf(this.tooltips);
        ImmutableList guiElements = this.guiElements == null ? ImmutableList.of() : ImmutableList.copyOf(this.guiElements);
        ImmutableList jeiElements = this.jeiElements == null ? ImmutableList.of() : ImmutableList.copyOf(this.jeiElements);
        ImmutableList catalysts = this.catalysts == null ? ImmutableList.of() : ImmutableList.copyOf(this.catalysts);
        ArrayList<IMachineComponentTemplate<? extends IMachineComponent>> componentTemplates = new ArrayList<IMachineComponentTemplate<? extends IMachineComponent>>();
        this.componentBuilders.forEach(builder -> componentTemplates.add(builder.build()));
        return new CustomMachine((class_2561)name, appearance, (List<class_2561>)tooltips, (List<IGuiElement>)guiElements, (List<IGuiElement>)jeiElements, (List<class_2960>)catalysts, componentTemplates, MachineProcessor.Template.DEFAULT).setLocation(this.location);
    }
}

