/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineShape;
import fr.frinn.custommachinery.impl.util.ModelLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_6862;

public class MachineAppearanceBuilder {
    private final Map<MachineAppearanceProperty<?>, Object> properties;

    public MachineAppearanceBuilder() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
            builder.put((Object)property, property.getDefaultValue());
        }
        this.properties = builder.build();
    }

    public MachineAppearanceBuilder(MachineAppearance appearance) {
        this.properties = Maps.newHashMap(appearance.getProperties());
    }

    public <T> T getProperty(MachineAppearanceProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalStateException("Can't get Machine Appearance property for: " + property.getId() + ", this property may not be registered");
        }
        return (T)this.properties.get(property);
    }

    public <T> void setProperty(MachineAppearanceProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public ModelLocation getBlockModel() {
        return (ModelLocation)this.getProperty((MachineAppearanceProperty)((Object)Registration.BLOCK_MODEL_PROPERTY.get()));
    }

    public void setBlockModel(ModelLocation blockModel) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.BLOCK_MODEL_PROPERTY.get()), blockModel);
    }

    public ModelLocation getItemModel() {
        return (ModelLocation)this.getProperty((MachineAppearanceProperty)((Object)Registration.ITEM_MODEL_PROPERTY.get()));
    }

    public void setItemModel(ModelLocation itemModel) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.ITEM_MODEL_PROPERTY.get()), itemModel);
    }

    public class_3414 getSound() {
        return (class_3414)this.getProperty((MachineAppearanceProperty)((Object)Registration.AMBIENT_SOUND_PROPERTY.get()));
    }

    public void setSound(class_3414 sound) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.AMBIENT_SOUND_PROPERTY.get()), sound);
    }

    public int getLightLevel() {
        return (Integer)this.getProperty((MachineAppearanceProperty)((Object)Registration.LIGHT_PROPERTY.get()));
    }

    public void setLightLevel(int lightLevel) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.LIGHT_PROPERTY.get()), class_3532.method_15340((int)lightLevel, (int)0, (int)15));
    }

    public int getColor() {
        return (Integer)this.getProperty((MachineAppearanceProperty)((Object)Registration.COLOR_PROPERTY.get()));
    }

    public void setColor(int color) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.COLOR_PROPERTY.get()), color);
    }

    public float getHardness() {
        return ((Float)this.getProperty((MachineAppearanceProperty)((Object)Registration.HARDNESS_PROPERTY.get()))).floatValue();
    }

    public void setHardness(float hardness) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.HARDNESS_PROPERTY.get()), Float.valueOf(class_3532.method_15363((float)hardness, (float)0.0f, (float)Float.MAX_VALUE)));
    }

    public float getResistance() {
        return ((Float)this.getProperty((MachineAppearanceProperty)((Object)Registration.RESISTANCE_PROPERTY.get()))).floatValue();
    }

    public void setResistance(float resistance) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.RESISTANCE_PROPERTY.get()), Float.valueOf(class_3532.method_15363((float)resistance, (float)0.0f, (float)Float.MAX_VALUE)));
    }

    public List<class_6862<class_2248>> getToolType() {
        return (List)this.getProperty((MachineAppearanceProperty)((Object)Registration.TOOL_TYPE_PROPERTY.get()));
    }

    public void setToolType(class_6862<class_2248> toolType) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.TOOL_TYPE_PROPERTY.get()), Collections.singletonList(toolType));
    }

    public class_6862<class_2248> getMiningLevel() {
        return (class_6862)this.getProperty((MachineAppearanceProperty)((Object)Registration.MINING_LEVEL_PROPERTY.get()));
    }

    public void setMiningLevel(class_6862<class_2248> miningLevel) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.MINING_LEVEL_PROPERTY.get()), miningLevel);
    }

    public MachineShape getShape() {
        return (MachineShape)this.getProperty((MachineAppearanceProperty)((Object)Registration.SHAPE_PROPERTY.get()));
    }

    public void setShape(MachineShape shape) {
        this.setProperty((MachineAppearanceProperty)((Object)Registration.SHAPE_PROPERTY.get()), shape);
    }

    public MachineAppearance build() {
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)ImmutableMap.copyOf(this.properties));
    }
}

