/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.client.ClientPacketHandler;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.PacketManager;
import io.netty.handler.codec.EncoderException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SUpdateMachinesPacket
extends BaseS2CMessage {
    private final Map<class_2960, CustomMachine> machines;

    public SUpdateMachinesPacket(Map<class_2960, CustomMachine> machines) {
        this.machines = new HashMap<class_2960, CustomMachine>(machines);
    }

    public MessageType getType() {
        return PacketManager.UPDATE_MACHINES;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.machines.size());
        this.machines.forEach((id, machine) -> {
            try {
                buf.method_10812(id);
                buf.method_29172(MachineLocation.CODEC, (Object)machine.getLocation());
                buf.method_29172(CustomMachine.CODEC, machine);
            }
            catch (EncoderException e) {
                e.printStackTrace();
            }
        });
    }

    public static SUpdateMachinesPacket decode(class_2540 buf) {
        HashMap<class_2960, CustomMachine> map = new HashMap<class_2960, CustomMachine>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            try {
                class_2960 id = buf.method_10810();
                MachineLocation location = (MachineLocation)buf.method_29171(MachineLocation.CODEC);
                CustomMachine machine = (CustomMachine)buf.method_29171(CustomMachine.CODEC);
                machine.setLocation(location);
                map.put(id, machine);
                continue;
            }
            catch (EncoderException e) {
                e.printStackTrace();
            }
        }
        return new SUpdateMachinesPacket(map);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.CLIENT) {
            context.queue(() -> ClientPacketHandler.handleUpdateMachinesPacket(this.machines));
        }
    }
}

