/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.PositionMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class BiomeRequirement
extends AbstractRequirement<PositionMachineComponent>
implements IDisplayInfoRequirement {
    public static final Codec<BiomeRequirement> CODEC = RecordCodecBuilder.create(biomeRequirementInstance -> biomeRequirementInstance.group((App)Codecs.list(class_2960.field_25139).fieldOf("filter").forGetter(requirement -> requirement.filter), (App)CodecLogger.loggedOptional(Codec.BOOL, "blacklist", false).forGetter(requirement -> requirement.blacklist)).apply((Applicative)biomeRequirementInstance, BiomeRequirement::new));
    private final List<class_2960> filter;
    private final boolean blacklist;

    public BiomeRequirement(List<class_2960> filter, boolean blacklist) {
        super(RequirementIOMode.INPUT);
        this.filter = filter;
        this.blacklist = blacklist;
    }

    @Override
    public RequirementType<BiomeRequirement> getType() {
        return (RequirementType)((Object)Registration.BIOME_REQUIREMENT.get());
    }

    @Override
    public boolean test(PositionMachineComponent component, ICraftingContext context) {
        class_2378 biomeRegistry = component.getManager().getLevel().method_30349().method_30530(class_2378.field_25114);
        return this.filter.stream().anyMatch(biome -> biomeRegistry.method_10223(biome) == component.getBiome()) != this.blacklist;
    }

    @Override
    public CraftingResult processStart(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<PositionMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.POSITION_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        if (!this.filter.isEmpty()) {
            if (this.blacklist) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.position.info.biome.blacklist").method_27692(class_124.field_1075));
            } else {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.position.info.biome.whitelist").method_27692(class_124.field_1075));
            }
            this.filter.forEach(biome -> info.addTooltip((class_2561)new class_2585("* ").method_10852((class_2561)new class_2588("biome." + biome.method_12836() + "." + biome.method_12832()))));
        }
        info.setItemIcon(class_1802.field_8895);
    }
}

