/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.PositionMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DimensionRequirement
extends AbstractRequirement<PositionMachineComponent>
implements IDisplayInfoRequirement {
    public static final Codec<DimensionRequirement> CODEC = RecordCodecBuilder.create(dimensionRequirementInstance -> dimensionRequirementInstance.group((App)Codecs.list(class_2960.field_25139).fieldOf("filter").forGetter(requirement -> requirement.filter), (App)CodecLogger.loggedOptional(Codec.BOOL, "blacklist", false).forGetter(requirement -> requirement.blacklist)).apply((Applicative)dimensionRequirementInstance, DimensionRequirement::new));
    private final List<class_2960> filter;
    private final boolean blacklist;

    public DimensionRequirement(List<class_2960> filter, boolean blacklist) {
        super(RequirementIOMode.INPUT);
        this.filter = filter;
        this.blacklist = blacklist;
    }

    @Override
    public RequirementType<DimensionRequirement> getType() {
        return (RequirementType)((Object)Registration.DIMENSION_REQUIREMENT.get());
    }

    @Override
    public boolean test(PositionMachineComponent component, ICraftingContext context) {
        return this.filter.contains(component.getDimension().method_29177()) != this.blacklist;
    }

    @Override
    public CraftingResult processStart(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<PositionMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.POSITION_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        if (!this.filter.isEmpty()) {
            if (this.blacklist) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.position.info.dimension.blacklist").method_27692(class_124.field_1079));
            } else {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.position.info.dimension.whitelist").method_27692(class_124.field_1077));
            }
            this.filter.forEach(dimension -> info.addTooltip((class_2561)new class_2585("* " + dimension)));
        }
        info.setSpriteIcon((class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(new class_2960("block/nether_portal")));
    }
}

