/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.EffectMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.RomanNumber;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class EffectRequirement
extends AbstractDelayedChanceableRequirement<EffectMachineComponent>
implements ITickableRequirement<EffectMachineComponent>,
IDisplayInfoRequirement {
    public static final Codec<EffectRequirement> CODEC = RecordCodecBuilder.create(effectRequirementInstance -> effectRequirementInstance.group((App)RegistrarCodec.EFFECT.fieldOf("effect").forGetter(requirement -> requirement.effect), (App)Codec.INT.fieldOf("time").forGetter(requirement -> requirement.time), (App)Codec.INT.fieldOf("radius").forGetter(requirement -> requirement.radius), (App)CodecLogger.loggedOptional(Codec.INT, "level", 1).forGetter(requirement -> requirement.level), (App)CodecLogger.loggedOptional(Codecs.list(RegistrarCodec.ENTITY), "filter", new ArrayList()).forGetter(requirement -> requirement.filter), (App)CodecLogger.loggedOptional(Codec.BOOL, "finish", false).forGetter(requirement -> requirement.applyAtEnd), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "delay", 0.0).forGetter(AbstractDelayedRequirement::getDelay), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance)).apply((Applicative)effectRequirementInstance, (effect, time, radius, level, filter, finish, delay, chance) -> {
        EffectRequirement requirement = new EffectRequirement((class_1291)effect, (int)time, (int)radius, (int)level, (List<class_1299<?>>)filter, (boolean)finish);
        requirement.setDelay((double)delay);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final class_1291 effect;
    private final int time;
    private final int level;
    private final int radius;
    private final List<class_1299<?>> filter;
    private final boolean applyAtEnd;

    public EffectRequirement(class_1291 effect, int time, int level, int radius, List<class_1299<?>> filter, boolean applyAtEnd) {
        super(RequirementIOMode.OUTPUT);
        this.effect = effect;
        this.time = time;
        this.level = level;
        this.radius = radius;
        this.filter = filter;
        this.applyAtEnd = applyAtEnd;
    }

    @Override
    public RequirementType<EffectRequirement> getType() {
        return (RequirementType)((Object)Registration.EFFECT_REQUIREMENT.get());
    }

    @Override
    public boolean test(EffectMachineComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public CraftingResult processStart(EffectMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(EffectMachineComponent component, ICraftingContext context) {
        if (this.applyAtEnd && this.getDelay() == 0.0) {
            int time = (int)context.getModifiedValue(this.time, this, "time");
            int level = class_3532.method_15340((int)((int)context.getModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
            int radius = (int)context.getModifiedValue(this.radius, this, "radius");
            component.applyEffect(new class_1293(this.effect, time, level - 1), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.method_5864()));
        }
        return CraftingResult.success();
    }

    @Override
    public CraftingResult processTick(EffectMachineComponent component, ICraftingContext context) {
        if (!this.applyAtEnd && this.getDelay() == 0.0) {
            int time = (int)context.getPerTickModifiedValue(this.time, this, "time");
            int level = class_3532.method_15340((int)((int)context.getPerTickModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
            int radius = (int)context.getPerTickModifiedValue(this.radius, this, "radius");
            component.applyEffect(new class_1293(this.effect, time, level), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.method_5864()));
        }
        return CraftingResult.success();
    }

    @Override
    public CraftingResult execute(EffectMachineComponent component, ICraftingContext context) {
        int time = (int)context.getPerTickModifiedValue(this.time, this, "time");
        int level = class_3532.method_15340((int)((int)context.getPerTickModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
        int radius = (int)context.getPerTickModifiedValue(this.radius, this, "radius");
        component.applyEffect(new class_1293(this.effect, time, level), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.method_5864()));
        return CraftingResult.success();
    }

    @Override
    public MachineComponentType<EffectMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.EFFECT_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        class_2561 level;
        class_5250 effect = new class_2585(this.effect.method_5560().getString()).method_27692(class_124.field_1075);
        Object object = level = this.level <= 0 ? class_2585.field_24366 : new class_2585(RomanNumber.toRoman(this.level)).method_27692(class_124.field_1065);
        if (this.applyAtEnd) {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.effect.info.end", new Object[]{effect, level, this.time, this.radius}));
        } else {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.effect.info.tick", new Object[]{effect, level, this.time, this.radius}));
        }
        if (!this.filter.isEmpty()) {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.effect.info.whitelist").method_27692(class_124.field_1075));
            this.filter.forEach(type -> info.addTooltip((class_2561)new class_2585("* ").method_10852((class_2561)new class_2588(type.method_5882()))));
        }
        info.setItemIcon(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8963));
    }
}

