/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.EnergyIngredientWrapper;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class EnergyPerTickRequirement
extends AbstractChanceableRequirement<EnergyMachineComponent>
implements ITickableRequirement<EnergyMachineComponent>,
IJEIIngredientRequirement<Energy> {
    public static final Codec<EnergyPerTickRequirement> CODEC = RecordCodecBuilder.create(energyPerTickRequirementInstance -> energyPerTickRequirementInstance.group((App)Codecs.REQUIREMENT_MODE_CODEC.fieldOf("mode").forGetter(IRequirement::getMode), (App)Codec.INT.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractChanceableRequirement::getChance)).apply((Applicative)energyPerTickRequirementInstance, (mode, amount, chance) -> {
        EnergyPerTickRequirement requirement = new EnergyPerTickRequirement((RequirementIOMode)((Object)((Object)mode)), (int)amount);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final int amount;

    public EnergyPerTickRequirement(RequirementIOMode mode, int amount) {
        super(mode);
        this.amount = amount;
    }

    @Override
    public RequirementType<EnergyPerTickRequirement> getType() {
        return (RequirementType)((Object)Registration.ENERGY_PER_TICK_REQUIREMENT.get());
    }

    @Override
    public MachineComponentType<EnergyMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get());
    }

    @Override
    public boolean test(EnergyMachineComponent energy, ICraftingContext context) {
        int amount = (int)context.getPerTickModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return energy.extractRecipeEnergy(amount, true) == amount;
        }
        return energy.receiveRecipeEnergy(amount, true) == amount;
    }

    @Override
    public CraftingResult processStart(EnergyMachineComponent energy, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processTick(EnergyMachineComponent energy, ICraftingContext context) {
        int amount = (int)context.getPerTickModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            int canExtract = energy.extractRecipeEnergy(amount, true);
            if (canExtract == amount) {
                energy.extractRecipeEnergy(amount, false);
                return CraftingResult.success();
            }
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.energypertick.error.input", new Object[]{amount, canExtract}));
        }
        int canReceive = energy.receiveRecipeEnergy(amount, true);
        if (canReceive == amount) {
            energy.receiveRecipeEnergy(amount, false);
            return CraftingResult.success();
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.energypertick.error.output", new Object[]{amount}));
    }

    @Override
    public CraftingResult processEnd(EnergyMachineComponent energy, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public List<IJEIIngredientWrapper<Energy>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new EnergyIngredientWrapper(this.getMode(), this.amount, this.getChance(), true, recipe.getRecipeTime()));
    }
}

