/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.EnergyIngredientWrapper;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class EnergyRequirement
extends AbstractChanceableRequirement<EnergyMachineComponent>
implements IJEIIngredientRequirement<Energy> {
    public static final Codec<EnergyRequirement> CODEC = RecordCodecBuilder.create(energyRequirementInstance -> energyRequirementInstance.group((App)Codecs.REQUIREMENT_MODE_CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)Codec.INT.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractChanceableRequirement::getChance)).apply((Applicative)energyRequirementInstance, (mode, amount, chance) -> {
        EnergyRequirement requirement = new EnergyRequirement((RequirementIOMode)((Object)((Object)mode)), (int)amount);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final int amount;

    public EnergyRequirement(RequirementIOMode mode, int amount) {
        super(mode);
        this.amount = amount;
    }

    @Override
    public RequirementType<EnergyRequirement> getType() {
        return (RequirementType)((Object)Registration.ENERGY_REQUIREMENT.get());
    }

    @Override
    public MachineComponentType<EnergyMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get());
    }

    @Override
    public boolean test(EnergyMachineComponent energy, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return energy.extractRecipeEnergy(amount, true) == amount;
        }
        return energy.receiveRecipeEnergy(amount, true) == amount;
    }

    @Override
    public CraftingResult processStart(EnergyMachineComponent energy, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            int canExtract = energy.extractRecipeEnergy(amount, true);
            if (canExtract == amount) {
                energy.extractRecipeEnergy(amount, false);
                return CraftingResult.success();
            }
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.energy.error.input", new Object[]{amount, canExtract}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(EnergyMachineComponent energy, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            int canReceive = energy.receiveRecipeEnergy(amount, true);
            if (canReceive == amount) {
                energy.receiveRecipeEnergy(amount, false);
                return CraftingResult.success();
            }
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.energy.error.output", new Object[]{amount}));
        }
        return CraftingResult.pass();
    }

    @Override
    public List<IJEIIngredientWrapper<Energy>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new EnergyIngredientWrapper(this.getMode(), this.amount, this.getChance(), false, recipe.getRecipeTime()));
    }
}

