/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.EntityMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class EntityRequirement
extends AbstractDelayedChanceableRequirement<EntityMachineComponent>
implements ITickableRequirement<EntityMachineComponent>,
IDisplayInfoRequirement {
    public static final Codec<EntityRequirement> CODEC = RecordCodecBuilder.create(entityRequirementInstance -> entityRequirementInstance.group((App)Codecs.REQUIREMENT_MODE_CODEC.fieldOf("mode").forGetter(IRequirement::getMode), (App)Codecs.ENTITY_REQUIREMENT_ACTION_CODEC.fieldOf("action").forGetter(requirement -> requirement.action), (App)Codec.INT.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)Codec.INT.fieldOf("radius").forGetter(requirement -> requirement.radius), (App)CodecLogger.loggedOptional(Codecs.list(RegistrarCodec.ENTITY), "filter", Collections.emptyList()).forGetter(requirement -> requirement.filter), (App)CodecLogger.loggedOptional(Codec.BOOL, "whitelist", false).forGetter(requirement -> requirement.whitelist), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "delay", 0.0).forGetter(AbstractDelayedRequirement::getDelay), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance)).apply((Applicative)entityRequirementInstance, (mode, action, amount, radius, filter, whitelist, delay, chance) -> {
        EntityRequirement requirement = new EntityRequirement((RequirementIOMode)((Object)((Object)mode)), (ACTION)((Object)((Object)action)), (int)amount, (int)radius, (List<class_1299<?>>)filter, (boolean)whitelist);
        requirement.setDelay((double)delay);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final ACTION action;
    private final int amount;
    private final int radius;
    private final List<class_1299<?>> filter;
    private final boolean whitelist;
    private final Predicate<class_1297> predicate;

    public EntityRequirement(RequirementIOMode mode, ACTION action, int amount, int radius, List<class_1299<?>> filter, boolean whitelist) {
        super(mode);
        this.action = action;
        this.amount = amount;
        this.radius = radius;
        this.filter = filter;
        this.whitelist = whitelist;
        this.predicate = entity -> filter.contains(entity.method_5864()) == whitelist;
    }

    @Override
    public RequirementType<EntityRequirement> getType() {
        return (RequirementType)((Object)Registration.ENTITY_REQUIREMENT.get());
    }

    @Override
    public boolean test(EntityMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        if (this.action == ACTION.CHECK_AMOUNT || this.action == ACTION.KILL) {
            return component.getEntitiesInRadius(radius, this.predicate) >= amount;
        }
        return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount;
    }

    @Override
    public CraftingResult processStart(EntityMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        if (this.getMode() == RequirementIOMode.INPUT) {
            switch (this.action) {
                case CHECK_AMOUNT: {
                    return component.getEntitiesInRadius(radius, this.predicate) >= amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
                case CHECK_HEALTH: {
                    return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case CONSUME_HEALTH: {
                    if (component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount) {
                        component.removeEntitiesHealth(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case KILL: {
                    if (component.getEntitiesInRadius(radius, this.predicate) >= amount) {
                        component.killEntities(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(EntityMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            switch (this.action) {
                case CONSUME_HEALTH: {
                    if (component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount) {
                        component.removeEntitiesHealth(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case KILL: {
                    if (component.getEntitiesInRadius(radius, this.predicate) >= amount) {
                        component.killEntities(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<EntityMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.ENTITY_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(EntityMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        if (this.action == ACTION.CHECK_AMOUNT) {
            return component.getEntitiesInRadius(radius, this.predicate) >= amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
        }
        if (this.action == ACTION.CHECK_HEALTH) {
            return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult execute(EntityMachineComponent component, ICraftingContext context) {
        switch (this.action) {
            case CONSUME_HEALTH: {
                if (component.getEntitiesInRadiusHealth(this.radius, this.predicate) >= (double)this.amount) {
                    component.removeEntitiesHealth(this.radius, this.predicate, this.amount);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{this.amount}));
            }
            case KILL: {
                if (component.getEntitiesInRadius(this.radius, this.predicate) >= this.amount) {
                    component.killEntities(this.radius, this.predicate, this.amount);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity." + this.action.toString().toLowerCase(Locale.ENGLISH) + ".info", new Object[]{this.amount, this.radius}));
        if (!this.filter.isEmpty()) {
            if (this.whitelist) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity.whitelist"));
            } else {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity.blacklist"));
            }
        }
        this.filter.forEach(type -> info.addTooltip((class_2561)new class_2585("*").method_10852(type.method_5897())));
        info.setItemIcon(class_1802.field_8433);
    }

    public static enum ACTION {
        CHECK_AMOUNT,
        CHECK_HEALTH,
        CONSUME_HEALTH,
        KILL;


        public static ACTION value(String mode) {
            return ACTION.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }
    }
}

