/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.FuelItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.FuelMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class FuelRequirement
extends AbstractRequirement<FuelMachineComponent>
implements ITickableRequirement<FuelMachineComponent>,
IJEIIngredientRequirement<class_1799> {
    public static final Codec<FuelRequirement> CODEC = RecordCodecBuilder.create(fuelRequirementInstance -> fuelRequirementInstance.group((App)CodecLogger.loggedOptional(Codec.intRange((int)0, (int)Integer.MAX_VALUE), "amount", 1).forGetter(requirement -> requirement.amount)).apply((Applicative)fuelRequirementInstance, FuelRequirement::new));
    private final int amount;

    public FuelRequirement(int amount) {
        super(RequirementIOMode.INPUT);
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public RequirementType<FuelRequirement> getType() {
        return (RequirementType)((Object)Registration.FUEL_REQUIREMENT.get());
    }

    @Override
    public boolean test(FuelMachineComponent component, ICraftingContext context) {
        return component.canStartRecipe(this.amount);
    }

    @Override
    public CraftingResult processStart(FuelMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processTick(FuelMachineComponent component, ICraftingContext context) {
        if (component.burn(this.amount)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.fuel.error"));
    }

    @Override
    public CraftingResult processEnd(FuelMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<FuelMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.FUEL_MACHINE_COMPONENT.get());
    }

    @Override
    public List<IJEIIngredientWrapper<class_1799>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new FuelItemIngredientWrapper(this.amount));
    }
}

