/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class ItemRequirement
extends AbstractChanceableRequirement<ItemComponentHandler>
implements IJEIIngredientRequirement<class_1799> {
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(itemRequirementInstance -> itemRequirementInstance.group((App)Codecs.REQUIREMENT_MODE_CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)IIngredient.ITEM.fieldOf("item").forGetter(requirement -> requirement.item), (App)Codec.INT.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)CodecLogger.loggedOptional(Codecs.COMPOUND_NBT_CODEC, "nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractChanceableRequirement::getChance), (App)CodecLogger.loggedOptional(Codec.STRING, "slot", "").forGetter(requirement -> requirement.slot)).apply((Applicative)itemRequirementInstance, (mode, item, amount, nbt, chance, slot) -> {
        ItemRequirement requirement = new ItemRequirement((RequirementIOMode)((Object)((Object)mode)), (IIngredient<class_1792>)item, (int)amount, nbt.orElse(null), (String)slot);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final IIngredient<class_1792> item;
    private final int amount;
    @Nullable
    private final class_2487 nbt;
    private final String slot;

    public ItemRequirement(RequirementIOMode mode, IIngredient<class_1792> item, int amount, @Nullable class_2487 nbt, String slot) {
        super(mode);
        if (mode == RequirementIOMode.OUTPUT && item instanceof ItemTagIngredient) {
            throw new IllegalArgumentException("You can't use a Tag for an Output Item Requirement");
        }
        this.item = item;
        this.amount = amount;
        this.nbt = nbt;
        this.slot = slot == null ? "" : slot;
    }

    @Override
    public RequirementType<ItemRequirement> getType() {
        return (RequirementType)((Object)Registration.ITEM_REQUIREMENT.get());
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return this.item.getAll().stream().mapToInt(item -> component.getItemAmount(this.slot, (class_1792)item, this.nbt)).sum() >= amount;
        }
        if (this.item.getAll().get(0) != null) {
            return component.getSpaceForItem(this.slot, this.item.getAll().get(0), this.nbt) >= amount;
        }
        throw new IllegalStateException("Can't use output item requirement with item tag");
    }

    @Override
    public CraftingResult processStart(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            int maxExtract = this.item.getAll().stream().mapToInt(item -> component.getItemAmount(this.slot, (class_1792)item, this.nbt)).sum();
            if (maxExtract >= amount) {
                int toExtract = amount;
                for (class_1792 item2 : this.item.getAll()) {
                    int canExtract = component.getItemAmount(this.slot, item2, this.nbt);
                    if (canExtract <= 0) continue;
                    canExtract = Math.min(canExtract, toExtract);
                    component.removeFromInputs(this.slot, item2, canExtract, this.nbt);
                    if ((toExtract -= canExtract) != 0) continue;
                    return CraftingResult.success();
                }
            }
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.item.error.input", new Object[]{this.item.toString(), amount, maxExtract}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            if (this.item.getAll().get(0) != null) {
                class_1792 item = this.item.getAll().get(0);
                int canInsert = component.getSpaceForItem(this.slot, item, this.nbt);
                if (canInsert >= amount) {
                    component.addToOutputs(this.slot, item, amount, this.nbt);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.item.error.output", new Object[]{amount, new class_2588(item.method_7876())}));
            }
            throw new IllegalStateException("Can't use output item requirement with item tag");
        }
        return CraftingResult.pass();
    }

    @Override
    public List<IJEIIngredientWrapper<class_1799>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new ItemIngredientWrapper(this.getMode(), this.item, this.amount, this.getChance(), false, this.nbt, this.slot));
    }
}

