/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class ItemTransformRequirement
extends AbstractChanceableRequirement<ItemComponentHandler>
implements IJEIIngredientRequirement<class_1799> {
    public static final Codec<ItemTransformRequirement> CODEC = RecordCodecBuilder.create(itemTransformRequirementInstance -> itemTransformRequirementInstance.group((App)IIngredient.ITEM.fieldOf("input").forGetter(requirement -> requirement.input), (App)CodecLogger.loggedOptional(Codec.intRange((int)1, (int)Integer.MAX_VALUE), "input_amount", 1).forGetter(requirement -> requirement.inputAmount), (App)CodecLogger.loggedOptional(Codec.STRING, "input_slot", "").forGetter(requirement -> requirement.inputSlot), (App)CodecLogger.loggedOptional(Codecs.COMPOUND_NBT_CODEC, "input_nbt").forGetter(requirement -> Optional.ofNullable(requirement.inputNBT)), (App)CodecLogger.loggedOptional(RegistrarCodec.ITEM, "output", class_1802.field_8162).forGetter(requirement -> requirement.output), (App)CodecLogger.loggedOptional(Codec.intRange((int)1, (int)Integer.MAX_VALUE), "output_amount", 1).forGetter(requirement -> requirement.outputAmount), (App)CodecLogger.loggedOptional(Codec.STRING, "output_slot", "").forGetter(requirement -> requirement.outputSlot), (App)CodecLogger.loggedOptional(Codec.BOOL, "copy_nbt", true).forGetter(requirement -> requirement.copyNBT), (App)CodecLogger.loggedOptional(Codec.doubleRange((double)0.0, (double)1.0), "chance", 1.0).forGetter(AbstractChanceableRequirement::getChance)).apply((Applicative)itemTransformRequirementInstance, (input, inputAmount, inputSlot, inputNBT, output, outputAmount, outputSlot, copyNBT, chance) -> {
        ItemTransformRequirement requirement = new ItemTransformRequirement((IIngredient<class_1792>)input, (int)inputAmount, (String)inputSlot, inputNBT.orElse(null), (class_1792)output, (int)outputAmount, (String)outputSlot, (boolean)copyNBT, null);
        requirement.setChance((double)chance);
        return requirement;
    }));
    private final IIngredient<class_1792> input;
    private final int inputAmount;
    private final String inputSlot;
    @Nullable
    private final class_2487 inputNBT;
    private final class_1792 output;
    private final int outputAmount;
    private final String outputSlot;
    private final boolean copyNBT;
    @Nullable
    private final Function<class_2487, class_2487> nbt;

    public ItemTransformRequirement(IIngredient<class_1792> input, int inputAmount, String inputSlot, @Nullable class_2487 inputNBT, class_1792 output, int outputAmount, String outputSlot, boolean copyNBT, @Nullable Function<class_2487, class_2487> nbt) {
        super(RequirementIOMode.OUTPUT);
        this.input = input;
        this.inputAmount = inputAmount;
        this.inputSlot = inputSlot;
        this.inputNBT = inputNBT;
        this.output = output;
        this.outputAmount = outputAmount;
        this.outputSlot = outputSlot;
        this.copyNBT = copyNBT;
        this.nbt = nbt;
    }

    @Override
    public RequirementType<ItemTransformRequirement> getType() {
        return (RequirementType)((Object)Registration.ITEM_TRANSFORM_REQUIREMENT.get());
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        return this.input.getAll().stream().anyMatch(item -> {
            if (component.getItemAmount(this.inputSlot, (class_1792)item, this.inputNBT) < this.inputAmount) {
                return false;
            }
            class_2487 inputNBT = component.getComponents().stream().filter(slot -> slot.getItemStack().method_7909() == item).findFirst().map(slot -> slot.getItemStack().method_7969()).map(class_2487::method_10553).orElse(null);
            class_2487 outputNBT = null;
            if (this.nbt != null) {
                outputNBT = this.nbt.apply(inputNBT);
            } else if (this.copyNBT && inputNBT != null) {
                outputNBT = inputNBT;
            }
            return component.getSpaceForItem(this.outputSlot, this.output == class_1802.field_8162 ? item : this.output, outputNBT) >= this.outputAmount;
        });
    }

    @Override
    public CraftingResult processStart(ItemComponentHandler component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(ItemComponentHandler component, ICraftingContext context) {
        for (class_1792 item : this.input.getAll()) {
            if (component.getItemAmount(this.inputSlot, item, this.inputNBT) < this.inputAmount) continue;
            class_2487 inputNBT = component.getComponents().stream().filter(slot -> slot.getItemStack().method_7909() == item).findFirst().map(slot -> slot.getItemStack().method_7969()).map(class_2487::method_10553).orElse(null);
            class_2487 outputNBT = null;
            if (this.nbt != null) {
                outputNBT = this.nbt.apply(inputNBT);
            } else if (this.copyNBT && inputNBT != null) {
                outputNBT = inputNBT;
            }
            if (component.getSpaceForItem(this.outputSlot, this.output == class_1802.field_8162 ? item : this.output, outputNBT) < this.outputAmount) continue;
            component.removeFromInputs(this.inputSlot, item, this.inputAmount, null);
            component.addToOutputs(this.outputSlot, this.output == class_1802.field_8162 ? item : this.output, this.outputAmount, outputNBT);
            return CraftingResult.success();
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.item_transform.error", new Object[]{this.input.toString(), this.inputAmount}));
    }

    @Override
    public List<IJEIIngredientWrapper<class_1799>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        class_2487 outputNBT = null;
        if (this.nbt != null) {
            outputNBT = this.nbt.apply(this.inputNBT == null ? null : this.inputNBT.method_10553());
        } else if (this.copyNBT && this.inputNBT != null) {
            outputNBT = this.inputNBT;
        }
        return Lists.newArrayList((Object[])new IJEIIngredientWrapper[]{new ItemIngredientWrapper(RequirementIOMode.INPUT, this.input, this.inputAmount, this.getChance(), false, this.inputNBT, this.inputSlot), new ItemIngredientWrapper(RequirementIOMode.OUTPUT, this.output == class_1802.field_8162 ? this.input : new ItemIngredient(this.output), this.outputAmount, this.getChance(), false, outputNBT, this.outputSlot)});
    }
}

