/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.LightMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class LightRequirement
extends AbstractRequirement<LightMachineComponent>
implements ITickableRequirement<LightMachineComponent>,
IDisplayInfoRequirement {
    public static final Codec<LightRequirement> CODEC = RecordCodecBuilder.create(lightRequirementInstance -> lightRequirementInstance.group((App)IntRange.CODEC.fieldOf("light").forGetter(requirement -> requirement.light), (App)CodecLogger.loggedOptional(Codec.BOOL, "sky", false).forGetter(requirement -> requirement.sky)).apply((Applicative)lightRequirementInstance, LightRequirement::new));
    private final IntRange light;
    private final boolean sky;

    public LightRequirement(IntRange light, boolean sky) {
        super(RequirementIOMode.INPUT);
        this.light = light;
        this.sky = sky;
    }

    @Override
    public RequirementType<?> getType() {
        return (RequirementType)((Object)Registration.LIGHT_REQUIREMENT.get());
    }

    @Override
    public boolean test(LightMachineComponent component, ICraftingContext context) {
        if (this.sky) {
            return this.light.contains(component.getSkyLight());
        }
        return this.light.contains(component.getBlockLight());
    }

    @Override
    public CraftingResult processStart(LightMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        if (this.sky) {
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.light.sky.error", new Object[]{this.light.toFormattedString(), component.getSkyLight()}));
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.light.block.error", new Object[]{this.light, component.getBlockLight()}));
    }

    @Override
    public CraftingResult processEnd(LightMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<LightMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.LIGHT_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(LightMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        if (this.sky) {
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.light.sky.error", new Object[]{this.light.toFormattedString(), component.getSkyLight()}));
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.light.block.error", new Object[]{this.light.toFormattedString(), component.getBlockLight()}));
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        if (this.sky) {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.light.sky.info", new Object[]{this.light.toFormattedString()}));
        } else {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.light.block.info", new Object[]{this.light.toFormattedString()}));
        }
        info.setItemIcon(class_1802.field_8810);
    }
}

