/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.LootTableIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class LootTableRequirement
extends AbstractRequirement<ItemComponentHandler>
implements IJEIIngredientRequirement<class_1799> {
    public static final Codec<LootTableRequirement> CODEC = RecordCodecBuilder.create(lootTableRequirementInstance -> lootTableRequirementInstance.group((App)class_2960.field_25139.fieldOf("table").forGetter(requirement -> requirement.lootTable), (App)CodecLogger.loggedOptional(Codec.FLOAT, "luck", Float.valueOf(0.0f)).forGetter(requirement -> Float.valueOf(requirement.luck))).apply((Applicative)lootTableRequirementInstance, LootTableRequirement::new));
    private final class_2960 lootTable;
    private final float luck;
    private List<class_1799> toOutput = Collections.emptyList();

    public LootTableRequirement(class_2960 lootTable, float luck) {
        super(RequirementIOMode.OUTPUT);
        this.lootTable = lootTable;
        this.luck = luck;
        LootTableHelper.addTable(lootTable);
    }

    @Override
    public RequirementType<LootTableRequirement> getType() {
        return (RequirementType)((Object)Registration.LOOT_TABLE_REQUIREMENT.get());
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        return true;
    }

    @Override
    public CraftingResult processStart(ItemComponentHandler component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(ItemComponentHandler component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT || context.getMachineTile().method_10997() == null || context.getMachineTile().method_10997().method_8503() == null) {
            return CraftingResult.pass();
        }
        if (this.toOutput.isEmpty()) {
            class_52 table = context.getMachineTile().method_10997().method_8503().method_3857().method_367(this.lootTable);
            class_47 lootContext = new class_47.class_48((class_3218)context.getMachineTile().method_10997()).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)context.getMachineTile().method_11016())).method_312(class_181.field_1228, (Object)context.getMachineTile()).method_303((float)context.getModifiedValue(this.luck, this, "luck")).method_309(Registration.CUSTOM_MACHINE_LOOT_PARAMETER_SET);
            this.toOutput = table.method_319(lootContext);
        }
        Iterator<class_1799> iterator = this.toOutput.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = iterator.next();
            if (component.getSpaceForItem("", stack.method_7909(), stack.method_7969()) < stack.method_7947()) {
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.item.error.output", new Object[]{stack.method_7947(), new class_2588(stack.method_7922())}));
            }
            component.addToOutputs("", stack.method_7909(), stack.method_7947(), stack.method_7969());
            iterator.remove();
        }
        return CraftingResult.success();
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
    }

    @Override
    public List<IJEIIngredientWrapper<class_1799>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new LootTableIngredientWrapper(this.lootTable));
    }
}

