/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.PositionMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class PositionRequirement
extends AbstractRequirement<PositionMachineComponent>
implements IDisplayInfoRequirement {
    public static final Codec<PositionRequirement> CODEC = RecordCodecBuilder.create(positionRequirementInstance -> positionRequirementInstance.group((App)CodecLogger.loggedOptional(IntRange.CODEC, "x", IntRange.ALL).forGetter(requirement -> requirement.x), (App)CodecLogger.loggedOptional(IntRange.CODEC, "y", IntRange.ALL).forGetter(requirement -> requirement.y), (App)CodecLogger.loggedOptional(IntRange.CODEC, "z", IntRange.ALL).forGetter(requirement -> requirement.z)).apply((Applicative)positionRequirementInstance, PositionRequirement::new));
    private final IntRange x;
    private final IntRange y;
    private final IntRange z;

    public PositionRequirement(IntRange x, IntRange y, IntRange z) {
        super(RequirementIOMode.INPUT);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public RequirementType<PositionRequirement> getType() {
        return (RequirementType)((Object)Registration.POSITION_REQUIREMENT.get());
    }

    @Override
    public boolean test(PositionMachineComponent component, ICraftingContext context) {
        class_2338 pos = component.getPosition();
        return this.x.contains(pos.method_10263()) && this.y.contains(pos.method_10264()) && this.z.contains(pos.method_10260());
    }

    @Override
    public CraftingResult processStart(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<PositionMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.POSITION_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.position.info.pos").method_27692(class_124.field_1075));
        info.addTooltip((class_2561)new class_2585("X: ").method_10852((class_2561)new class_2585(this.x.toFormattedString())));
        info.addTooltip((class_2561)new class_2585("Y: ").method_10852((class_2561)new class_2585(this.y.toFormattedString())));
        info.addTooltip((class_2561)new class_2585("Z: ").method_10852((class_2561)new class_2585(this.z.toFormattedString())));
        info.setItemIcon(class_1802.field_8251);
    }
}

