/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.common.component.StructureMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class StructureRequirement
extends AbstractRequirement<StructureMachineComponent>
implements ITickableRequirement<StructureMachineComponent>,
IDisplayInfoRequirement {
    public static final Codec<StructureRequirement> CODEC = RecordCodecBuilder.create(structureRequirementInstance -> structureRequirementInstance.group((App)Codecs.list(Codecs.list(Codec.STRING)).fieldOf("pattern").forGetter(requirement -> requirement.pattern), (App)Codec.unboundedMap(Codecs.CHARACTER_CODEC, IIngredient.BLOCK).fieldOf("keys").forGetter(requirement -> requirement.keys)).apply((Applicative)structureRequirementInstance, StructureRequirement::new));
    private final List<List<String>> pattern;
    private final Map<Character, IIngredient<PartialBlockState>> keys;
    private final BlockStructure structure;

    public StructureRequirement(List<List<String>> pattern, Map<Character, IIngredient<PartialBlockState>> keys) {
        super(RequirementIOMode.INPUT);
        this.pattern = pattern;
        this.keys = keys;
        BlockStructure.Builder builder = BlockStructure.Builder.start();
        for (List<String> list : pattern) {
            builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : keys.entrySet()) {
            builder.where(((Character)entry.getKey()).charValue(), (IIngredient)entry.getValue());
        }
        this.structure = builder.build();
    }

    @Override
    public RequirementType<StructureRequirement> getType() {
        return (RequirementType)((Object)Registration.STRUCTURE_REQUIREMENT.get());
    }

    @Override
    public boolean test(StructureMachineComponent component, ICraftingContext context) {
        return component.checkStructure(this.structure);
    }

    @Override
    public CraftingResult processStart(StructureMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(StructureMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<StructureMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.STRUCTURE_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(StructureMachineComponent component, ICraftingContext context) {
        if (component.checkStructure(this.structure)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.structure.error"));
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.structure.info"));
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.structure.click"));
        this.pattern.stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((key, amount) -> {
            IIngredient<PartialBlockState> ingredient = this.keys.get(key);
            if (ingredient != null && amount > 0L) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.structure.list", new Object[]{amount, new class_2585(ingredient.toString()).method_27692(class_124.field_1065)}));
            }
        });
        info.setClickAction((machine, mouseButton) -> CustomMachineRenderer.addRenderBlock(machine.getId(), this.structure::getBlocks));
        info.setItemIcon(class_1802.field_8238);
    }
}

