/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.TextComponentUtils;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class RecipeModifier
implements IRecipeModifier {
    public static final Codec<RecipeModifier> CODEC = RecordCodecBuilder.create(energyModifierInstance -> energyModifierInstance.group((App)RegistrarCodec.REQUIREMENT.fieldOf("requirement").forGetter(modifier -> modifier.requirementType), (App)Codecs.REQUIREMENT_MODE_CODEC.fieldOf("mode").forGetter(modifier -> modifier.mode), (App)Codecs.MODIFIER_OPERATION_CODEC.fieldOf("operation").forGetter(modifier -> modifier.operation), (App)Codec.DOUBLE.fieldOf("modifier").forGetter(modifier -> modifier.modifier), (App)CodecLogger.loggedOptional(Codec.STRING, "target", "").forGetter(modifier -> modifier.target), (App)CodecLogger.loggedOptional(Codec.DOUBLE, "chance", 1.0).forGetter(modifier -> modifier.chance), (App)CodecLogger.loggedOptional(Codec.DOUBLE, "max", Double.POSITIVE_INFINITY).forGetter(modifier -> modifier.max), (App)CodecLogger.loggedOptional(Codec.DOUBLE, "min", Double.NEGATIVE_INFINITY).forGetter(modifier -> modifier.min), (App)CodecLogger.loggedOptional(TextComponentUtils.CODEC, "tooltip", class_2585.field_24366).forGetter(modifier -> modifier.tooltip)).apply((Applicative)energyModifierInstance, RecipeModifier::new));
    private final RequirementType<?> requirementType;
    private final String target;
    private final RequirementIOMode mode;
    private final IRecipeModifier.OPERATION operation;
    private final double modifier;
    private final double chance;
    private final double max;
    private final double min;
    private final class_2561 tooltip;

    public RecipeModifier(RequirementType<?> requirementType, RequirementIOMode mode, IRecipeModifier.OPERATION operation, double modifier, String target, double chance, double max, double min, @Nullable class_2561 tooltip) {
        this.requirementType = requirementType;
        this.target = target;
        this.mode = mode;
        this.operation = operation;
        this.modifier = modifier;
        this.chance = chance;
        this.max = max;
        this.min = min;
        this.tooltip = tooltip != null && tooltip != class_2585.field_24366 ? tooltip : RecipeModifier.getDefaultTooltip(this);
    }

    @Override
    public RequirementType<?> getRequirementType() {
        return this.requirementType;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public RequirementIOMode getMode() {
        return this.mode;
    }

    @Override
    public IRecipeModifier.OPERATION getOperation() {
        return this.operation;
    }

    @Override
    public double getModifier() {
        return this.modifier;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public class_2561 getTooltip() {
        return this.tooltip;
    }

    public static class_2561 getDefaultTooltip(RecipeModifier modifier) {
        double tooltipModifier = modifier.operation == IRecipeModifier.OPERATION.ADDITION ? modifier.modifier : modifier.modifier * 100.0 - 100.0;
        StringBuilder tooltip = new StringBuilder(tooltipModifier >= 0.0 ? "+" : "");
        tooltip.append(modifier.operation == IRecipeModifier.OPERATION.ADDITION ? Double.valueOf(tooltipModifier) : tooltipModifier + "%");
        tooltip.append(" ");
        tooltip.append(modifier.requirementType.getName().getString());
        if (modifier.requirementType != Registration.SPEED_REQUIREMENT.get()) {
            tooltip.append(" ");
            tooltip.append(new class_2588(modifier.mode.getTranslationKey()).getString());
        }
        return new class_2585(tooltip.toString());
    }
}

