/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class CMLogger {
    public static final Logger INSTANCE = CustomMachinery.LOGGER;
    public static final String NAME = "Custom Machinery";
    private static boolean shouldReset = false;

    public static void init() {
        Appender serverGuiConsole;
        Appender console;
        Appender file;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout logPattern = PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss.SSS}][%level]: %msg%n%throwable").build();
        TriggeringPolicy policy = new TriggeringPolicy(){

            public void initialize(RollingFileManager manager) {
            }

            public boolean isTriggeringEvent(LogEvent logEvent) {
                if (shouldReset) {
                    shouldReset = false;
                    return true;
                }
                return false;
            }
        };
        RolloverStrategy strategy = manager -> new RolloverDescriptionImpl(manager.getFileName(), true, (Action)new AbstractAction(){

            public boolean execute() throws IOException {
                new FileWriter(manager.getFileName(), false).close();
                return false;
            }
        }, null);
        RollingFileAppender cmAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName("logs/custommachinery.log").withAppend(false).withFilePattern("logs/custommachinery-%i.log.gz").withPolicy(policy).withStrategy(strategy).setName(NAME)).withImmediateFlush(true)).setIgnoreExceptions(false)).setConfiguration(config)).setLayout((Layout)logPattern)).build();
        cmAppender.start();
        config.addAppender((Appender)cmAppender);
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)NAME, (String)"true", (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)cmAppender, CMConfig.get().debugLevel.getLevel(), null);
        Appender debug = config.getAppender("DebugFile");
        if (debug != null) {
            loggerConfig.addAppender(debug, Level.WARN, null);
        }
        if ((file = config.getAppender("File")) != null) {
            loggerConfig.addAppender(file, Level.WARN, null);
        }
        if ((console = config.getAppender("Console")) != null) {
            loggerConfig.addAppender(console, Level.WARN, null);
        }
        if ((serverGuiConsole = config.getAppender("ServerGuiConsole")) != null) {
            loggerConfig.addAppender(serverGuiConsole, Level.WARN, null);
        }
        config.addLogger(NAME, loggerConfig);
        ctx.updateLoggers();
    }

    public static void reset() {
        shouldReset = true;
    }

    public static void setDebugLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig cmConfig = (LoggerConfig)config.getLoggers().get(NAME);
        if (cmConfig == null) {
            throw new IllegalStateException("Custom Machinery logger not present!");
        }
        Appender cmAppender = (Appender)cmConfig.getAppenders().get(NAME);
        if (cmAppender == null) {
            throw new IllegalStateException("Custom Machinery appender not present");
        }
        cmConfig.removeAppender(NAME);
        cmConfig.addAppender(cmAppender, level, null);
    }
}

