/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.component.WeatherMachineComponent;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.guielement.TextGuiElement;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.requirement.BlockRequirement;
import fr.frinn.custommachinery.common.requirement.DropRequirement;
import fr.frinn.custommachinery.common.requirement.EntityRequirement;
import fr.frinn.custommachinery.common.util.ComparatorMode;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.codec.EnhancedEitherCodec;
import fr.frinn.custommachinery.impl.codec.EnhancedListCodec;
import fr.frinn.custommachinery.impl.codec.EnumCodec;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.util.ModelLocation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class Codecs {
    public static final Codec<DoubleStream> DOUBLE_STREAM = new PrimitiveCodec<DoubleStream>(){

        public <T> DataResult<DoubleStream> read(DynamicOps<T> ops, T input) {
            return ops.getStream(input).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> ops.getNumberValue(element).result().isPresent())) {
                    return DataResult.success((Object)list.stream().mapToDouble(element -> ((Number)ops.getNumberValue(element).result().get()).doubleValue()));
                }
                return DataResult.error((String)("Some elements are not doubles: " + input));
            });
        }

        public <T> T write(DynamicOps<T> ops, DoubleStream value) {
            return (T)ops.createList(value.mapToObj(arg_0 -> ops.createDouble(arg_0)));
        }

        public String toString() {
            return "DoubleStream";
        }
    };
    public static final Codec<class_2487> COMPOUND_NBT_CODEC = CodecLogger.namedCodec(Codec.STRING.comapFlatMap(Codecs::decodeCompoundNBT, class_2487::toString), "NBT");
    public static final Codec<Character> CHARACTER_CODEC = CodecLogger.namedCodec(Codec.STRING.comapFlatMap(Codecs::decodeCharacter, Object::toString), "Character");
    public static final Codec<PartialBlockState> PARTIAL_BLOCK_STATE_CODEC = CodecLogger.namedCodec(Codec.STRING.comapFlatMap(Codecs::decodePartialBlockState, PartialBlockState::toString), "Block State");
    public static final Codec<ComparatorMode> COMPARATOR_MODE_CODEC = CodecLogger.namedCodec(Codec.STRING.comapFlatMap(Codecs::decodeComparatorMode, ComparatorMode::getPrefix), "Comparator Mode");
    public static final Codec<ComponentIOMode> COMPONENT_MODE_CODEC = Codecs.fromEnum(ComponentIOMode.class);
    public static final Codec<RequirementIOMode> REQUIREMENT_MODE_CODEC = Codecs.fromEnum(RequirementIOMode.class);
    public static final Codec<MachineLocation.Loader> LOADER_CODEC = Codecs.fromEnum(MachineLocation.Loader.class);
    public static final Codec<TextGuiElement.Alignment> ALIGNMENT_CODEC = Codecs.fromEnum(TextGuiElement.Alignment.class);
    public static final Codec<MachineProcessor.PHASE> PHASE_CODEC = Codecs.fromEnum(MachineProcessor.PHASE.class);
    public static final Codec<WeatherMachineComponent.WeatherType> WEATHER_TYPE_CODEC = Codecs.fromEnum(WeatherMachineComponent.WeatherType.class);
    public static final Codec<EntityRequirement.ACTION> ENTITY_REQUIREMENT_ACTION_CODEC = Codecs.fromEnum(EntityRequirement.ACTION.class);
    public static final Codec<BlockRequirement.ACTION> BLOCK_REQUIREMENT_ACTION_CODEC = Codecs.fromEnum(BlockRequirement.ACTION.class);
    public static final Codec<IRecipeModifier.OPERATION> MODIFIER_OPERATION_CODEC = Codecs.fromEnum(IRecipeModifier.OPERATION.class);
    public static final Codec<ProgressBarGuiElement.Orientation> PROGRESS_DIRECTION = Codecs.fromEnum(ProgressBarGuiElement.Orientation.class);
    public static final Codec<DropRequirement.Action> DROP_REQUIREMENT_ACTION_CODEC = Codecs.fromEnum(DropRequirement.Action.class);
    public static final Codec<class_2338> BLOCK_POS = CodecLogger.namedCodec(class_2338.field_25064, "Block Position");
    public static final Codec<class_238> AABB_CODEC = CodecLogger.namedCodec(DOUBLE_STREAM.comapFlatMap(stream -> Codecs.validateDoubleStreamSize(stream, 6).map(array -> new class_238(array[0], array[1], array[2], array[3], array[4], array[5])), box -> DoubleStream.of(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324)), "Box");
    public static final Codec<class_238> BOX_CODEC = Codecs.either(BLOCK_POS, AABB_CODEC, "Box").xmap(either -> (class_238)either.map(pos -> new class_238(pos, pos), Function.identity()), Either::right);
    public static final Codec<ModelLocation> BLOCK_MODEL_CODEC = Codecs.either(ModelLocation.CODEC, PARTIAL_BLOCK_STATE_CODEC, "Block Model").xmap(either -> (ModelLocation)either.map(Function.identity(), PartialBlockState::getModelLocation), Either::left);
    public static final Codec<ModelLocation> ITEM_MODEL_CODEC = Codecs.either(RegistrarCodec.ITEM, ModelLocation.CODEC, "Item Model").xmap(either -> (ModelLocation)either.map(item -> ModelLocation.of(class_2378.field_11142.method_10221(item)), Function.identity()), Either::right);

    public static Codec<Long> longRange(long minInclusive, long maxInclusive) {
        Function<Long, DataResult<Long>> checker = Codecs.checkRange(minInclusive, maxInclusive);
        return Codec.LONG.flatXmap(checker, checker);
    }

    public static <E extends Enum<E>> Codec<E> fromEnum(Class<E> enumClass) {
        return EnumCodec.of(enumClass);
    }

    public static <F, S> Codec<Either<F, S>> either(Codec<F> first, Codec<S> second, String name) {
        return new EnhancedEitherCodec<F, S>(first, second, name);
    }

    public static <T> Codec<List<T>> list(Codec<T> codec) {
        return new EnhancedListCodec<T>(codec);
    }

    private static DataResult<class_2487> decodeCompoundNBT(String encoded) {
        try {
            return DataResult.success((Object)class_2522.method_10718((String)encoded));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Not a valid NBT: " + encoded + " " + e.getMessage()));
        }
    }

    private static DataResult<Character> decodeCharacter(String encoded) {
        if (encoded.length() != 1) {
            return DataResult.error((String)("Invalid character : \"" + encoded + "\" must be a single character !"));
        }
        return DataResult.success((Object)Character.valueOf(encoded.charAt(0)));
    }

    private static DataResult<PartialBlockState> decodePartialBlockState(String encoded) {
        StringReader reader = new StringReader(encoded);
        try {
            class_2259 parser = new class_2259(reader, false).method_9678(true);
            return DataResult.success((Object)new PartialBlockState(parser.method_9669(), Lists.newArrayList(parser.method_9692().keySet()), parser.method_9694()));
        }
        catch (CommandSyntaxException exception) {
            return DataResult.error((String)exception.getMessage());
        }
    }

    public static DataResult<double[]> validateDoubleStreamSize(DoubleStream stream, int size) {
        double[] array = stream.limit(size + 1).toArray();
        if (array.length != size) {
            String s = "Input is not a list of " + size + " doubles";
            return array.length >= size ? DataResult.error((String)s, (Object)Arrays.copyOf(array, size)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)array);
    }

    public static DataResult<ComparatorMode> decodeComparatorMode(String encoded) {
        try {
            return DataResult.success((Object)((Object)ComparatorMode.value(encoded)));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)("Invalid Comparator mode : " + encoded));
        }
    }

    public static <N extends Number> Function<N, DataResult<N>> checkRange(N minInclusive, N maxInclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minInclusive) >= 0 && ((Comparable)((Object)value)).compareTo(maxInclusive) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)("Value " + value + " outside of range [" + minInclusive + ":" + maxInclusive + "]"), (Object)value);
        };
    }
}

