/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;

public class EitherManyCodec<T>
implements Codec<T> {
    private final Codec<T> mainCodec;
    private final Codec<T>[] otherCodecs;

    @SafeVarargs
    public static <T> EitherManyCodec<T> of(Codec<T> mainCodec, Codec<T> ... otherCodecs) {
        return new EitherManyCodec<T>(mainCodec, otherCodecs);
    }

    private EitherManyCodec(Codec<T> mainCodec, Codec<T>[] otherCodecs) {
        this.mainCodec = mainCodec;
        this.otherCodecs = otherCodecs;
    }

    public <O> DataResult<Pair<T, O>> decode(DynamicOps<O> ops, O input) {
        StringBuilder error = new StringBuilder();
        for (Codec codec : Lists.asList(this.mainCodec, (Object[])this.otherCodecs)) {
            DataResult result = codec.decode(ops, input);
            if (result.result().isPresent()) {
                return result;
            }
            if (!result.error().isPresent()) continue;
            error.append(((DataResult.PartialResult)result.error().get()).message());
        }
        return DataResult.error((String)error.toString());
    }

    public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
        return this.mainCodec.encode(input, ops, prefix);
    }
}

