/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class MachineShape
implements Function<class_2350, class_265> {
    private static final Codec<List<class_238>> BOX_CODEC = Codecs.list(Codecs.BOX_CODEC);
    private static final Codec<Map<class_2350, List<class_238>>> MAP_CODEC = Codec.unboundedMap((Codec)class_2350.field_29502, BOX_CODEC);
    public static final Codec<MachineShape> CODEC = new Codec<MachineShape>(){

        public <T> DataResult<Pair<MachineShape, T>> decode(DynamicOps<T> ops, T input) {
            DataResult block = Codecs.PARTIAL_BLOCK_STATE_CODEC.parse(ops, input);
            if (block.result().isPresent()) {
                class_2680 state = ((PartialBlockState)block.result().get()).getBlockState();
                EnumMap shapes = Maps.newEnumMap(class_2350.class);
                try {
                    for (class_2350 side2 : class_2350.values()) {
                        shapes.put(side2, state.method_26218(null, null));
                    }
                }
                catch (Exception e) {
                    return DataResult.error((String)("Can't mimic shape of block: " + block.result().get()));
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult boxes = BOX_CODEC.parse(ops, input);
            if (boxes.result().isPresent()) {
                class_265 shape = MachineShape.fromAABBList((List)boxes.result().get());
                EnumMap shapes = Maps.newEnumMap(class_2350.class);
                for (class_2350 side3 : class_2350.values()) {
                    if (side3.method_10166() == class_2350.class_2351.field_11052) continue;
                    shapes.put(side3, MachineShape.rotateShape(class_2350.field_11043, side3, shape));
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult map = MAP_CODEC.parse(ops, input);
            if (map.result().isPresent()) {
                EnumMap shapes = Maps.newEnumMap(class_2350.class);
                ((Map)map.result().get()).forEach((side, box) -> shapes.put(side, MachineShape.fromAABBList(box)));
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            return DataResult.error((String)("Can't parse block shape: " + input));
        }

        public <T> DataResult<T> encode(MachineShape input, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            input.shapes.forEach((side, shape) -> builder.add(side.method_10151(), BOX_CODEC.encodeStart(ops, (Object)shape.method_1090())));
            return builder.build(prefix);
        }

        public String toString() {
            return "Machine Shape";
        }
    };
    public static final MachineShape DEFAULT = new MachineShape();
    private final Map<class_2350, class_265> shapes = Maps.newEnumMap(class_2350.class);

    public MachineShape() {
        for (class_2350 side : class_2350.values()) {
            this.shapes.put(side, class_259.method_1077());
        }
    }

    public MachineShape(Map<class_2350, class_265> shapes) {
        this.shapes.putAll(shapes);
    }

    @Override
    public class_265 apply(class_2350 side) {
        return this.shapes.get(side);
    }

    private static class_265 fromAABBList(List<class_238> list) {
        class_265 shape = class_259.method_1073();
        for (class_238 box : list) {
            class_265 partial = class_259.method_1078((class_238)box);
            shape = class_259.method_1082((class_265)shape, (class_265)partial, (class_247)class_247.field_1366);
        }
        return shape;
    }

    private static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        if (from == to) {
            return shape;
        }
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }
}

