/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.util.ModelLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PartialBlockState
implements Predicate<class_2694> {
    public static final PartialBlockState AIR = new PartialBlockState(class_2246.field_10124.method_9564(), new ArrayList(), null);
    public static final PartialBlockState ANY = new PartialBlockState(class_2246.field_10124.method_9564(), (List)new ArrayList(), null){

        @Override
        public boolean test(class_2694 cachedBlockInfo) {
            return true;
        }

        @Override
        public String toString() {
            return "ANY";
        }
    };
    private class_2680 blockState;
    private List<class_2769<?>> properties;
    private class_2487 nbt;

    public PartialBlockState(class_2680 blockState, List<class_2769<?>> properties, class_2487 nbt) {
        this.blockState = blockState;
        this.properties = properties;
        this.nbt = nbt;
    }

    public PartialBlockState(class_2248 block) {
        this(block.method_9564(), new ArrayList(), null);
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public List<String> getProperties() {
        return this.properties.stream().map(property -> property.method_11899() + "=" + this.blockState.method_11654(property)).toList();
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public PartialBlockState rotate(class_2470 rotation) {
        if (this.properties.contains(class_2741.field_12481) && this.blockState.method_28498((class_2769)class_2741.field_12481) && this.blockState.method_26204() != Registration.CUSTOM_MACHINE_BLOCK.get()) {
            class_2350 direction = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12481);
            direction = rotation.method_10503(direction);
            class_2680 blockState = (class_2680)this.blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)direction);
            ArrayList properties = Lists.newArrayList(this.properties);
            if (!properties.contains(class_2741.field_12481)) {
                properties.add(class_2741.field_12481);
            }
            return new PartialBlockState(blockState, properties, this.nbt);
        }
        return this;
    }

    @Override
    public boolean test(class_2694 cachedBlockInfo) {
        class_2680 blockstate = cachedBlockInfo.method_11681();
        if (!blockstate.method_27852(this.blockState.method_26204())) {
            return false;
        }
        for (class_2769<?> property : this.properties) {
            if (blockstate.method_11654(property) == this.blockState.method_11654(property)) continue;
            return false;
        }
        if (this.nbt == null) {
            return true;
        }
        class_2586 tileentity = cachedBlockInfo.method_11680();
        return tileentity != null && class_2512.method_10687((class_2520)this.nbt, (class_2520)tileentity.method_38242(), (boolean)true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(class_2378.field_11146.method_10221((Object)this.blockState.method_26204()));
        if (!this.properties.isEmpty()) {
            builder.append("[");
        }
        Iterator<class_2769<?>> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            class_2769<?> property = iterator.next();
            Comparable value = this.blockState.method_11654(property);
            builder.append(property.method_11899());
            builder.append("=");
            builder.append(value);
            if (iterator.hasNext()) {
                builder.append(",");
                continue;
            }
            builder.append("]");
        }
        if (this.nbt != null && !this.nbt.method_33133()) {
            builder.append(this.nbt);
        }
        return builder.toString();
    }

    public class_5250 getName() {
        return new class_2588(this.blockState.method_26204().method_9539());
    }

    public ModelLocation getModelLocation() {
        class_2960 location = class_2378.field_11146.method_10221((Object)this.blockState.method_26204());
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry entry : this.getBlockState().method_11656().entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(',');
            }
            class_2769 property = (class_2769)entry.getKey();
            stringbuilder.append(property.method_11899());
            stringbuilder.append('=');
            stringbuilder.append(PartialBlockState.getPropertyValueString(property, (Comparable)entry.getValue()));
        }
        String properties = stringbuilder.toString();
        return ModelLocation.of(location, properties);
    }

    private static <T extends Comparable<T>> String getPropertyValueString(class_2769<T> property, Comparable<?> value) {
        return property.method_11901(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartialBlockState)) {
            return false;
        }
        PartialBlockState other = (PartialBlockState)o;
        if (this.blockState != other.blockState) {
            return false;
        }
        if (!new HashSet(this.properties).containsAll(other.properties) || !new HashSet(other.properties).containsAll(this.properties)) {
            return false;
        }
        return class_2512.method_10687((class_2520)this.nbt, (class_2520)other.nbt, (boolean)true);
    }
}

