/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.TagUtil;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class BlockTagIngredient
implements IIngredient<PartialBlockState> {
    public static final Codec<BlockTagIngredient> CODEC = class_6862.method_40090((class_5321)class_2378.field_25105).xmap(BlockTagIngredient::new, ingredient -> ingredient.tag);
    private final class_6862<class_2248> tag;
    private final Supplier<List<PartialBlockState>> ingredients;

    private BlockTagIngredient(class_6862<class_2248> tag) {
        this.tag = tag;
        this.ingredients = Suppliers.memoize(() -> (List)TagUtil.getBlocks(this.tag).map(PartialBlockState::new).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf)));
    }

    public BlockTagIngredient create(class_6862<class_2248> tag) {
        return new BlockTagIngredient(tag);
    }

    @Override
    public List<PartialBlockState> getAll() {
        return this.ingredients.get();
    }

    @Override
    public boolean test(PartialBlockState partialBlockState) {
        return this.ingredients.get().stream().anyMatch(state -> state.getBlockState() == partialBlockState.getBlockState());
    }

    public String toString() {
        return "#" + this.tag.comp_327();
    }
}

