/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.TagUtil;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class FluidTagIngredient
implements IIngredient<class_3611> {
    private static final Codec<FluidTagIngredient> CODEC_FOR_DATAPACK = Codec.STRING.xmap(FluidTagIngredient::create, FluidTagIngredient::toString);
    private static final Codec<FluidTagIngredient> CODEC_FOR_KUBEJS = class_6862.method_40090((class_5321)class_2378.field_25103).fieldOf("tag").codec().xmap(FluidTagIngredient::new, ingredient -> ingredient.tag);
    public static final Codec<FluidTagIngredient> CODEC = Codecs.either(CODEC_FOR_DATAPACK, CODEC_FOR_KUBEJS, "Fluid Tag Ingredient").xmap(either -> (FluidTagIngredient)either.map(Function.identity(), Function.identity()), Either::left);
    private final class_6862<class_3611> tag;

    private FluidTagIngredient(class_6862<class_3611> tag) {
        this.tag = tag;
    }

    public static FluidTagIngredient create(String s) throws IllegalArgumentException {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (!Utils.isResourceNameValid(s)) {
            throw new IllegalArgumentException(String.format("Invalid tag id : %s", s));
        }
        class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)new class_2960(s));
        return new FluidTagIngredient((class_6862<class_3611>)tag);
    }

    public static FluidTagIngredient create(class_6862<class_3611> tag) throws IllegalArgumentException {
        return new FluidTagIngredient(tag);
    }

    @Override
    public List<class_3611> getAll() {
        return TagUtil.getFluids(this.tag).toList();
    }

    @Override
    public boolean test(class_3611 fluid) {
        return this.getAll().contains(fluid);
    }

    public String toString() {
        return "#" + this.tag.comp_327();
    }
}

