/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.BlockTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_3611;

public interface IIngredient<T>
extends Predicate<T> {
    public static final Codec<IIngredient<class_1792>> ITEM = Codecs.either(ItemIngredient.CODEC, ItemTagIngredient.CODEC, "Item Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof ItemIngredient) {
            return DataResult.success((Object)Either.left((Object)((ItemIngredient)ingredient)));
        }
        if (ingredient instanceof ItemTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((ItemTagIngredient)ingredient)));
        }
        return DataResult.error((String)String.format("Item Ingredient : %s is not an item nor a tag !", ingredient));
    });
    public static final Codec<IIngredient<class_3611>> FLUID = Codecs.either(FluidIngredient.CODEC, FluidTagIngredient.CODEC, "Fluid Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof FluidIngredient) {
            return DataResult.success((Object)Either.left((Object)((FluidIngredient)ingredient)));
        }
        if (ingredient instanceof FluidTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((FluidTagIngredient)ingredient)));
        }
        return DataResult.error((String)String.format("Fluid Ingredient : %s is not a fluid nor a tag !", ingredient));
    });
    public static final Codec<IIngredient<PartialBlockState>> BLOCK = Codecs.either(BlockIngredient.CODEC, BlockTagIngredient.CODEC, "Block Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof BlockIngredient) {
            return DataResult.success((Object)Either.left((Object)((BlockIngredient)ingredient)));
        }
        if (ingredient instanceof BlockTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((BlockTagIngredient)ingredient)));
        }
        return DataResult.error((String)String.format("Block Ingredient : %s is not a block nor a tag !", ingredient));
    });

    public List<T> getAll();
}

