/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.TagUtil;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class ItemTagIngredient
implements IIngredient<class_1792> {
    private static final Codec<ItemTagIngredient> CODEC_FOR_DATAPACK = Codec.STRING.xmap(ItemTagIngredient::create, ItemTagIngredient::toString);
    private static final Codec<ItemTagIngredient> CODEC_FOR_KUBEJS = class_6862.method_40090((class_5321)class_2378.field_25108).fieldOf("tag").codec().xmap(ItemTagIngredient::new, ingredient -> ingredient.tag);
    public static final Codec<ItemTagIngredient> CODEC = Codecs.either(CODEC_FOR_DATAPACK, CODEC_FOR_KUBEJS, "Item Tag Ingredient").xmap(either -> (ItemTagIngredient)either.map(Function.identity(), Function.identity()), Either::left);
    private final class_6862<class_1792> tag;

    private ItemTagIngredient(class_6862<class_1792> tag) {
        this.tag = tag;
    }

    public static ItemTagIngredient create(String s) throws IllegalArgumentException {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (!Utils.isResourceNameValid(s)) {
            throw new IllegalArgumentException(String.format("Invalid tag id : %s", s));
        }
        class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(s));
        return new ItemTagIngredient((class_6862<class_1792>)tag);
    }

    public static ItemTagIngredient create(class_6862<class_1792> tag) throws IllegalArgumentException {
        return new ItemTagIngredient(tag);
    }

    @Override
    public List<class_1792> getAll() {
        return TagUtil.getItems(this.tag).toList();
    }

    @Override
    public boolean test(class_1792 item) {
        return TagUtil.getItems(this.tag).anyMatch(Predicate.isEqual(item));
    }

    public String toString() {
        return "#" + this.tag.comp_327();
    }
}

