/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import fr.frinn.custommachinery.fabric.client.ClientHandler;
import fr.frinn.custommachinery.fabric.integration.jade.CMWailaPlugin;
import fr.frinn.custommachinery.fabric.transfer.FabricEnergyHandler;
import fr.frinn.custommachinery.fabric.transfer.FabricFluidHandler;
import fr.frinn.custommachinery.fabric.transfer.FabricItemHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import team.reborn.energy.api.EnergyStorage;

public class CustomMachineryFabric
implements ModInitializer {
    public void onInitialize() {
        CustomMachinery.init();
        if (Platform.isModLoaded((String)"jade")) {
            CMWailaPlugin.addMachineBlockToPickedResults();
        }
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(this::afterDatapackReload);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(this::syncDatapacks);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> ClientHandler::init);
        this.createHandlers();
    }

    private void afterDatapackReload(MinecraftServer server, class_3300 manager, boolean success) {
        if (success) {
            LootTableHelper.generate(server);
        }
    }

    private void syncDatapacks(class_3222 player, boolean joined) {
        CustomMachinery.syncData(player);
    }

    private void createHandlers() {
        EnergyStorage.SIDED.registerForBlockEntity((machine, side) -> machine.getComponentManager().getComponent((MachineComponentType)((Object)((Object)Registration.ENERGY_MACHINE_COMPONENT.get()))).map(component -> ((FabricEnergyHandler)component.getEnergyHandler()).getStorage((class_2350)side)).orElse(null), (class_2591)Registration.CUSTOM_MACHINE_TILE.get());
        FluidStorage.SIDED.registerForBlockEntity((machine, side) -> machine.getComponentManager().getComponentHandler((MachineComponentType)((Object)((Object)Registration.FLUID_MACHINE_COMPONENT.get()))).map(handler -> ((FabricFluidHandler)((FluidComponentHandler)handler).getCommonFluidHandler()).getFluidStorage((class_2350)side)).orElse(null), (class_2591)Registration.CUSTOM_MACHINE_TILE.get());
        ItemStorage.SIDED.registerForBlockEntity((machine, side) -> machine.getComponentManager().getComponentHandler((MachineComponentType)((Object)((Object)Registration.ITEM_MACHINE_COMPONENT.get()))).map(handler -> ((FabricItemHandler)((ItemComponentHandler)handler).getCommonHandler()).getItemStorage((class_2350)side)).orElse(null), (class_2591)Registration.CUSTOM_MACHINE_TILE.get());
    }
}

