/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.client;

import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.fabric.client.CustomMachineOverrideList;
import fr.frinn.custommachinery.impl.util.ModelLocation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class CustomMachineBakedModel
implements class_1087,
FabricBakedModel {
    private final Map<MachineStatus, class_2960> defaults;

    public CustomMachineBakedModel(Map<MachineStatus, class_2960> defaults) {
        this.defaults = defaults;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        Optional.ofNullable(blockView.method_8321(pos)).filter(be -> be instanceof MachineTile).map(be -> (MachineTile)((Object)be)).ifPresentOrElse(machine -> {
            context.pushTransform((RenderContext.QuadTransform)QuadRotator.fromDirection((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
            context.fallbackConsumer().accept(this.getMachineBlockModel(machine.getAppearance(), machine.getStatus()));
            context.popTransform();
        }, () -> context.fallbackConsumer().accept(this));
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        context.fallbackConsumer().accept(this);
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, Random random) {
        return this.getModel(this.defaults.get((Object)MachineStatus.IDLE)).method_4707(blockState, direction, random);
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return true;
    }

    public class_1058 method_4711() {
        return this.getModel(this.defaults.get((Object)MachineStatus.IDLE)).method_4711();
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return CustomMachineOverrideList.INSTANCE;
    }

    public class_1087 getMachineBlockModel(IMachineAppearance appearance, @Nullable MachineStatus status) {
        class_2248 block;
        class_1087 missing = class_310.method_1551().method_1554().method_4744();
        ModelLocation blockModelLocation = appearance.getBlockModel();
        class_1087 model = blockModelLocation.getProperties() != null ? this.getModel((class_2960)new class_1091(blockModelLocation.toString())) : ((block = (class_2248)class_2378.field_11146.method_10223(blockModelLocation.getLoc())) != class_2246.field_10124 ? class_310.method_1551().method_1554().method_4742(class_773.method_3340((class_2680)block.method_9564())) : this.getModel(blockModelLocation.getLoc()));
        if (model == missing) {
            model = this.getModel(this.defaults.get((Object)(status == null ? MachineStatus.IDLE : status)));
        }
        return model;
    }

    public class_1087 getMachineItemModel(@Nullable MachineAppearance appearance) {
        class_1087 missing;
        class_1087 model = missing = class_310.method_1551().method_1554().method_4744();
        if (appearance != null) {
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(appearance.getItemModel().getLoc());
            if (item != class_1802.field_8162 && class_310.method_1551().method_1480().method_4012().method_3304(item) != null) {
                model = class_310.method_1551().method_1480().method_4012().method_3304(item);
            }
            if (model == missing) {
                model = this.getModel((class_2960)new class_1091(appearance.getItemModel().toString()));
            }
            if (model == this.getModel(this.defaults.get((Object)MachineStatus.IDLE)) || model == missing) {
                class_1792 item2 = (class_1792)class_2378.field_11142.method_10223(appearance.getBlockModel().getLoc());
                if (item2 != class_1802.field_8162 && class_310.method_1551().method_1480().method_4012().method_3304(item2) != null) {
                    model = class_310.method_1551().method_1480().method_4012().method_3304(item2);
                }
                if (model == missing) {
                    model = this.getMachineBlockModel(appearance, MachineStatus.IDLE);
                }
            }
        }
        if (model == missing) {
            model = this.getModel(this.defaults.get((Object)MachineStatus.IDLE));
        }
        return model;
    }

    private class_1087 getModel(class_2960 loc) {
        return class_310.method_1551().method_1554().field_5408.getOrDefault(loc, class_310.method_1551().method_1554().method_4744());
    }

    private static enum QuadRotator implements RenderContext.QuadTransform
    {
        NORTH(class_2350.field_11043, class_1160.field_20704.method_23214(0.0f)),
        SOUTH(class_2350.field_11035, class_1160.field_20704.method_23214(180.0f)),
        EAST(class_2350.field_11034, class_1160.field_20704.method_23214(90.0f)),
        WEST(class_2350.field_11039, class_1160.field_20704.method_23214(270.0f));

        private final class_2350 facing;
        private final class_1158 rotation;

        public static QuadRotator fromDirection(class_2350 direction) {
            return switch (direction) {
                case class_2350.field_11035 -> SOUTH;
                case class_2350.field_11034 -> EAST;
                case class_2350.field_11039 -> WEST;
                default -> NORTH;
            };
        }

        private QuadRotator(class_2350 facing, class_1158 rotation) {
            this.facing = facing;
            this.rotation = rotation;
        }

        public boolean transform(MutableQuadView quad) {
            for (int index = 0; index < 4; ++index) {
                class_1160 vec = quad.copyPos(index, null);
                vec.method_4948(-0.5f, -0.5f, -0.5f);
                vec.method_19262(this.rotation);
                vec.method_4948(0.5f, 0.5f, 0.5f);
                quad.pos(index, vec);
                class_1160 normal = quad.copyNormal(index, null);
                if (normal == null) continue;
                normal.method_4948(-0.5f, -0.5f, -0.5f);
                normal.method_19262(this.rotation);
                normal.method_4952();
                normal.method_4948(0.5f, 0.5f, 0.5f);
                quad.normal(index, normal);
            }
            quad.cullFace(this.getRotatedDirection(this.facing, quad.cullFace()));
            return true;
        }

        public class_2350 getRotatedDirection(class_2350 machineFacing, @Nullable class_2350 quad) {
            if (quad == null || quad.method_10166() == class_2350.class_2351.field_11052) {
                return quad;
            }
            return switch (machineFacing) {
                case class_2350.field_11039 -> class_2350.method_10139((int)((quad.method_10161() + 3) % 4));
                case class_2350.field_11035 -> class_2350.method_10139((int)((quad.method_10161() + 2) % 4));
                case class_2350.field_11034 -> class_2350.method_10139((int)((quad.method_10161() + 1) % 4));
                default -> quad;
            };
        }
    }
}

