/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class EnergyBuffer
extends SnapshotParticipant<Long>
implements EnergyStorage {
    @Nullable
    private final class_2350 side;
    private final EnergyMachineComponent component;

    public EnergyBuffer(EnergyMachineComponent component, @Nullable class_2350 side) {
        this.side = side;
        this.component = component;
    }

    protected Long createSnapshot() {
        return this.component.getEnergy();
    }

    protected void readSnapshot(Long snapshot) {
        this.component.setEnergy(snapshot);
    }

    protected void onFinalCommit() {
        this.component.getManager().markDirty();
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isInput()) {
            return 0L;
        }
        long maxInsert = this.component.receiveEnergy(maxAmount, true);
        if (maxInsert > 0L) {
            this.updateSnapshots(transaction);
            this.component.receiveEnergy(maxAmount, false);
            return maxInsert;
        }
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isOutput()) {
            return 0L;
        }
        long maxExtract = this.component.extractEnergy(maxAmount, true);
        if (maxExtract > 0L) {
            this.updateSnapshots(transaction);
            this.component.extractEnergy(maxAmount, false);
            return maxExtract;
        }
        return 0L;
    }

    public long getAmount() {
        return this.component.getEnergy();
    }

    public long getCapacity() {
        return this.component.getCapacity();
    }

    public boolean supportsInsertion() {
        return this.side != null && this.component.getConfig().getSideMode(this.side).isInput();
    }

    public boolean supportsExtraction() {
        return this.side != null && this.component.getConfig().getSideMode(this.side).isOutput();
    }
}

