/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;

public class CodecLogger {
    public static <T, E> Codec<E> loggedDispatch(Codec<T> keyCodec, Function<? super E, ? extends T> type, Function<? super T, ? extends Codec<? extends E>> codec, String name) {
        return CodecLogger.dispatch(keyCodec, type.andThen(DataResult::success), codec.andThen(DataResult::success), name);
    }

    private static <K, V> Codec<V> dispatch(Codec<K> keyCodec, final Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Codec<? extends V>>> codec, final String name) {
        return KeyDispatchCodec.unsafe((String)"type", keyCodec, type, codec, v -> CodecLogger.getCodec(type, codec, v)).codec().mapResult(new Codec.ResultFunction<V>(){

            public <T> DataResult<Pair<V, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<V, T>> a) {
                return a.mapError(s -> {
                    String[] words = s.split(" ");
                    if (words.length >= 5 && words[0].equals("No") && words[1].equals("key") && words[3].equals("in")) {
                        s = String.format("Error while deserializing: %s%nMissing mandatory property: %s", ops.getGeneric(input, ops.createString("type")).result().orElse(ops.createString("")), words[2]);
                    }
                    return String.format("Error while deserializing %s: %s%n%s", name, ops.getGeneric(input, ops.createString("type")).result().orElse(ops.createString("")), s);
                });
            }

            public <T> DataResult<T> coApply(DynamicOps<T> ops, V input, DataResult<T> t) {
                return t.mapError(s -> String.format("Error while serializing %s: %s%n%s", name, ((DataResult)type.apply(input)).result().orElse(null), s));
            }
        }).promotePartial(arg_0 -> ((Logger)ICustomMachineryAPI.INSTANCE.logger()).error(arg_0));
    }

    private static <K, V> DataResult<? extends Encoder<V>> getCodec(Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Encoder<? extends V>>> encoder, V input) {
        return type.apply(input).flatMap(k -> ((DataResult)encoder.apply((Object)k)).map(Function.identity())).map(c -> c);
    }

    public static <T> Codec<T> loggedRecord(Function<RecordCodecBuilder.Instance<T>, ? extends App<RecordCodecBuilder.Mu<T>, T>> builder) {
        return RecordCodecBuilder.create(builder).mapResult(new Codec.ResultFunction<T>(){

            public <T1> DataResult<Pair<T, T1>> apply(DynamicOps<T1> ops, T1 input, DataResult<Pair<T, T1>> a) {
                return a.mapError(s -> {
                    String[] words = s.split(" ");
                    if (words.length >= 5 && words[0].equals("No") && words[1].equals("key") && words[3].equals("in")) {
                        return String.format("Error while deserializing: %s%nMissing mandatory property: %s", ops.getGeneric(input, ops.createString("type")).result().orElse(ops.createString("")), words[2]);
                    }
                    return s;
                });
            }

            public <T1> DataResult<T1> coApply(DynamicOps<T1> ops, T input, DataResult<T1> t) {
                return t;
            }
        });
    }

    public static <T> Codec<T> namedCodec(final Codec<T> codec, final String name) {
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                return codec.decode(ops, input);
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return codec.encode(input, ops, prefix);
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <E> MapCodec<Optional<E>> loggedOptional(Codec<E> codec, String field) {
        return codec.optionalFieldOf(field);
    }

    public static <E> MapCodec<E> loggedOptional(final Codec<E> codec, final String field, final E defaultValue) {
        return new MapCodec<E>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return codec.fieldOf(field).keys(ops);
            }

            public <T> DataResult<E> decode(DynamicOps<T> ops, MapLike<T> input) {
                Object value = input.get(field);
                if (value == null) {
                    if (ICustomMachineryAPI.INSTANCE.config().logMissingOptional()) {
                        ICustomMachineryAPI.INSTANCE.logger().warn("Missing optional property: \"{}\" of type: {}\nUsing default value: {}", (Object)field, (Object)codec, defaultValue);
                    }
                    return DataResult.success((Object)defaultValue);
                }
                DataResult result = codec.parse(ops, value);
                if (result.error().isPresent()) {
                    ICustomMachineryAPI.INSTANCE.logger().warn("Error while deserializing optional property \"{}\" of type: {}\n{}\nUsing default value: {}", (Object)field, (Object)codec, (Object)((DataResult.PartialResult)result.error().get()).message(), defaultValue);
                    return DataResult.success((Object)defaultValue);
                }
                return result;
            }

            public <T> RecordBuilder<T> encode(E input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                if (Objects.equals(input, defaultValue)) {
                    return prefix;
                }
                return prefix.add(field, codec.encodeStart(ops, input));
            }
        };
    }
}

