/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnhancedListCodec<A>
implements Codec<List<A>> {
    private final Codec<A> elementCodec;

    public EnhancedListCodec(Codec<A> elementCodec) {
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<T> encode(List<A> input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (A a : input) {
            builder.add(this.elementCodec.encodeStart(ops, a));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops.getStream(input).error().isPresent()) {
            return this.elementCodec.decode(ops, input).map(pair -> Pair.of(Collections.singletonList(pair.getFirst()), (Object)pair.getSecond()));
        }
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            ImmutableList.Builder read = ImmutableList.builder();
            Stream.Builder failed = Stream.builder();
            MutableObject result = new MutableObject((Object)DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()));
            stream.accept(t -> {
                DataResult element = this.elementCodec.decode(ops, t);
                element.error().ifPresent(e -> failed.add(t));
                result.setValue((Object)((DataResult)result.getValue()).apply2stable((r, v) -> {
                    read.add(v.getFirst());
                    return r;
                }, element));
            });
            ImmutableList elements = read.build();
            Object errors = ops.createList(failed.build());
            Pair pair = Pair.of((Object)elements, (Object)errors);
            return ((DataResult)result.getValue()).map(unit -> pair).setPartial((Object)pair);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnhancedListCodec listCodec = (EnhancedListCodec)o;
        return Objects.equals(this.elementCodec, listCodec.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.elementCodec);
    }

    public String toString() {
        return "List[" + this.elementCodec + "]";
    }
}

