/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class EnumMapCodec<K extends Enum<K>, V>
extends MapCodec<Map<K, V>> {
    private final Class<K> keyEnum;
    private final Codec<K> keyCodec;
    private final Codec<V> valueCodec;
    @Nullable
    private final V defaultValue;

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, Codec<K> keyCodec, Codec<V> valueCodec) {
        return new EnumMapCodec<K, Object>(keyEnum, keyCodec, valueCodec, null);
    }

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, Codec<K> keyCodec, Codec<V> valueCodec, V defaultValue) {
        return new EnumMapCodec<K, V>(keyEnum, keyCodec, valueCodec, defaultValue);
    }

    public EnumMapCodec(Class<K> keyEnum, Codec<K> keyCodec, Codec<V> valueCodec, @Nullable V defaultValue) {
        this.keyEnum = keyEnum;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.defaultValue = defaultValue;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Arrays.stream((Enum[])this.keyEnum.getEnumConstants()).map(k -> ops.createString(k.toString()));
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        EnumMap map = Maps.newEnumMap(this.keyEnum);
        Object defaultValue = this.defaultValue;
        if (input.get("default") != null) {
            DataResult defaultResult = this.valueCodec.parse(ops, input.get("default"));
            if (defaultResult.result().isPresent()) {
                defaultValue = defaultResult.result().get();
            } else if (defaultResult.error().isPresent()) {
                ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't parse value for key {} in MapLike {}, {}", (Object)"default", (Object)input.toString(), (Object)((DataResult.PartialResult)defaultResult.error().get()).message());
            }
        }
        input.entries().forEach(entry -> {
            DataResult keyResult = this.keyCodec.parse(ops, entry.getFirst());
            if (keyResult.result().isPresent()) {
                Enum key = (Enum)keyResult.result().get();
                DataResult valueResult = this.valueCodec.parse(ops, entry.getSecond());
                if (valueResult.result().isPresent()) {
                    map.put(key, valueResult.result().get());
                } else if (valueResult.error().isPresent()) {
                    ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't parse value for key {} in MapLike {}, {}", (Object)key.toString(), (Object)input.toString(), (Object)((DataResult.PartialResult)valueResult.error().get()).message());
                }
            }
        });
        if (defaultValue != null) {
            for (Enum key : (Enum[])this.keyEnum.getEnumConstants()) {
                if (map.containsKey(key)) continue;
                map.put(key, defaultValue);
            }
        }
        return DataResult.success((Object)map);
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        input.forEach((key, value) -> prefix.add(this.keyCodec.encodeStart(ops, key), this.valueCodec.encodeStart(ops, value)));
        return prefix;
    }

    public String toString() {
        return "EnumMap[" + this.keyCodec.toString() + ", " + this.valueCodec.toString() + "]";
    }
}

