/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.guielement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import net.minecraft.class_2960;

public abstract class AbstractTexturedGuiElement
extends AbstractGuiElement {
    private final class_2960 texture;

    public AbstractTexturedGuiElement(int x, int y, int width, int height, int priority, class_2960 texture) {
        super(x, y, width, height, priority);
        this.texture = texture;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    @Override
    public int getWidth() {
        if (super.getWidth() >= 0) {
            return super.getWidth();
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            return TextureSizeHelper.getTextureWidth(this.texture);
        }
        return -1;
    }

    @Override
    public int getHeight() {
        if (super.getHeight() >= 0) {
            return super.getHeight();
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            return TextureSizeHelper.getTextureHeight(this.texture);
        }
        return -1;
    }

    public static <T extends AbstractTexturedGuiElement> Products.P6<RecordCodecBuilder.Mu<T>, Integer, Integer, Integer, Integer, Integer, class_2960> makeBaseTexturedCodec(RecordCodecBuilder.Instance<T> texturedGuiElement, class_2960 defaultTexture) {
        return AbstractTexturedGuiElement.makeBaseCodec(texturedGuiElement).and((App)CodecLogger.loggedOptional(class_2960.field_25139, "texture", defaultTexture).forGetter(AbstractTexturedGuiElement::getTexture));
    }
}

