/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import org.jetbrains.annotations.Nullable;

public record Restriction<T extends Comparable<T>>(@Nullable T lowerBound, boolean lowerBoundInclusive, @Nullable T upperBound, boolean upperBoundInclusive) {
    public boolean contains(T thing) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo(thing);
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo(thing);
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            return comparison >= 0;
        }
        return true;
    }

    public String toFormattedString() {
        if (this.lowerBound == null && this.upperBound == null) {
            return "Any";
        }
        if (this.lowerBound != null && this.upperBound == null) {
            return (this.lowerBoundInclusive ? "From " : "Greater than ") + this.lowerBound;
        }
        if (this.lowerBound == null) {
            return (this.upperBoundInclusive ? "Up to " : "Less than ") + this.upperBound;
        }
        if (this.lowerBound == this.upperBound) {
            return "Only " + this.lowerBound;
        }
        return "Between " + this.lowerBound + (this.lowerBoundInclusive ? " (included)" : "") + " and " + this.upperBound + (this.upperBoundInclusive ? " (included)" : "");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Restriction)) {
            return false;
        }
        Restriction restriction = (Restriction)other;
        if (this.lowerBound != null && !this.lowerBound.equals(restriction.lowerBound)) {
            return false;
        }
        if (restriction.lowerBound != null) {
            return false;
        }
        if (this.lowerBoundInclusive != restriction.lowerBoundInclusive) {
            return false;
        }
        if (this.upperBound != null && !this.upperBound.equals(restriction.upperBound)) {
            return false;
        }
        if (restriction.upperBound != null) {
            return false;
        }
        return this.upperBoundInclusive == restriction.upperBoundInclusive;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.lowerBoundInclusive() ? (char)'[' : '(');
        if (this.lowerBound() != null) {
            buf.append(this.lowerBound());
        }
        buf.append(',');
        if (this.upperBound() != null) {
            buf.append(this.upperBound());
        }
        buf.append(this.upperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

