/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TextureSizeHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_2960, Pair<Integer, Integer>> SIZES = new HashMap<class_2960, Pair<Integer, Integer>>();

    public static int getTextureWidth(@Nullable class_2960 texture) {
        if (texture == null) {
            return 0;
        }
        if (SIZES.containsKey(texture)) {
            return (Integer)SIZES.get(texture).getLeft();
        }
        try {
            BufferedImage image = ImageIO.read(class_310.method_1551().method_1478().method_14486(texture).method_14482());
            int width = image.getWidth();
            int height = image.getHeight();
            Pair sizes = Pair.of((Object)width, (Object)height);
            SIZES.put(texture, (Pair<Integer, Integer>)sizes);
            return width;
        }
        catch (IOException e) {
            LOGGER.warn("No texture found for location: " + texture);
            return 0;
        }
    }

    public static int getTextureHeight(@Nullable class_2960 texture) {
        if (texture == null) {
            return 0;
        }
        if (SIZES.containsKey(texture)) {
            return (Integer)SIZES.get(texture).getRight();
        }
        try {
            BufferedImage image = ImageIO.read(class_310.method_1551().method_1478().method_14486(texture).method_14482());
            int width = image.getWidth();
            int height = image.getHeight();
            Pair sizes = Pair.of((Object)width, (Object)height);
            SIZES.put(texture, (Pair<Integer, Integer>)sizes);
            return height;
        }
        catch (IOException e) {
            LOGGER.warn("No texture found for location: " + texture);
            return 0;
        }
    }
}

