/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.datapackportals;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.kyrptonaught.customportalapi.PerWorldPortals;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.ColorUtil;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.kyrptonaught.datapackportals.PortalData;
import net.kyrptonaught.datapackportals.PortalLinkDataPackLoader;
import net.kyrptonaught.datapackportals.PortalTypeRecord;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3611;

public class DatapackPortalsMod
implements ModInitializer {
    public static final String MOD_ID = "datapackportals";
    public static List<PortalTypeRecord> PortalTypeRegisters = new ArrayList<PortalTypeRecord>();

    public void onInitialize() {
        DatapackPortalsMod.registerPortalType("portals", DefaultPortalData.class);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new PortalLinkDataPackLoader());
    }

    public static void registerDatapackPortal(PortalLink portalLink) {
        PerWorldPortals.registerWorldPortal((PortalLink)portalLink);
    }

    public static <T extends PortalData> void registerPortalType(String folderPath, Class<T> deserializer) {
        PortalTypeRegisters.add(new PortalTypeRecord(folderPath, deserializer));
    }

    public static void logerror(String message) {
        System.out.println("[datapackportals]: " + message);
    }

    public static class DefaultPortalData
    implements PortalData {
        public String block;
        public String ignitionType;
        public String ignitionSource;
        public String dim;
        public String returnDim;
        public int r;
        public int g;
        public int b;

        @Override
        public PortalLink toLink(class_2960 identifier) {
            if (this.block == null) {
                DatapackPortalsMod.logerror(identifier + " missing field: block");
            }
            if (this.ignitionType == null) {
                DatapackPortalsMod.logerror(identifier + " missing field: ignitionType");
            }
            if (this.ignitionSource == null) {
                DatapackPortalsMod.logerror(identifier + " missing field: ignitionSource");
            }
            if (this.dim == null) {
                DatapackPortalsMod.logerror(identifier + " missing field: dim");
            }
            PortalLink link = new PortalLink(new class_2960(this.block), new class_2960(this.dim), ColorUtil.getColorFromRGB((int)this.r, (int)this.g, (int)this.b));
            if (this.ignitionType.equalsIgnoreCase("block")) {
                link.portalIgnitionSource = PortalIgnitionSource.FIRE;
            } else if (this.ignitionType.equalsIgnoreCase("fluid")) {
                link.portalIgnitionSource = PortalIgnitionSource.FluidSource((class_3611)((class_3611)class_2378.field_11154.method_10223(new class_2960(this.ignitionSource))));
            } else if (this.ignitionType.equalsIgnoreCase("item")) {
                link.portalIgnitionSource = PortalIgnitionSource.ItemUseSource((class_1792)((class_1792)class_2378.field_11142.method_10223(new class_2960(this.ignitionSource))));
            }
            if (this.returnDim != null) {
                link.returnDimID = new class_2960(this.returnDim);
            }
            return link;
        }
    }
}

