/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import lombok.NonNull;
import me.lortseam.completeconfig.CompleteConfig;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.data.ConfigRegistry;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.data.extension.BaseExtension;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class Config
extends Parent {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private final String modId;
    private final String[] branch;
    private final HoconConfigurationLoader loader;
    private Runnable resolver;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;

    private static HoconConfigurationLoader createLoader(Consumer<HoconConfigurationLoader.Builder> builderConsumer) {
        HoconConfigurationLoader.Builder builder = (HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(options -> options.serializers(typeSerializerCollection -> {
            for (TypeSerializerCollection typeSerializers : CompleteConfig.collectExtensions(BaseExtension.class, BaseExtension::getTypeSerializers)) {
                typeSerializerCollection.registerAll(typeSerializers);
            }
        }));
        builderConsumer.accept(builder);
        return builder.build();
    }

    public Config(@NonNull String modId, @NonNull String[] branch, ConfigContainer ... containers) {
        if (modId == null) {
            throw new NullPointerException("modId is marked non-null but is null");
        }
        if (branch == null) {
            throw new NullPointerException("branch is marked non-null but is null");
        }
        if (containers == null) {
            throw new NullPointerException("containers is marked non-null but is null");
        }
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            throw new IllegalArgumentException("Mod " + modId + " is not loaded");
        }
        Arrays.stream(branch).forEach(Objects::requireNonNull);
        Arrays.stream(containers).forEach(Objects::requireNonNull);
        this.modId = modId;
        this.branch = branch;
        this.loader = Config.createLoader(builder -> {
            Path path = FabricLoader.getInstance().getConfigDir();
            String[] subPath = (String[])ArrayUtils.addFirst((Object[])branch, (Object)modId);
            subPath[subPath.length - 1] = subPath[subPath.length - 1] + ".conf";
            for (String child : subPath) {
                path = path.resolve(child);
            }
            builder.path(path);
        });
        this.resolver = () -> {
            if (this instanceof ConfigContainer) {
                this.resolve((ConfigContainer)((Object)this));
            }
            this.resolve(containers);
            if (this.isEmpty()) {
                logger.warn(this + " is empty");
            }
        };
        ConfigRegistry.register(this);
    }

    public Config(String modId, ConfigContainer ... containers) {
        this(modId, new String[0], containers);
    }

    public final ModMetadata getMod() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(this.modId).get()).getMetadata();
    }

    @Override
    public final TranslationKey getTranslation() {
        return this.getTranslation(false);
    }

    @Environment(value=EnvType.CLIENT)
    public final TranslationKey getTranslation(boolean includeBranch) {
        if (this.translation == null) {
            this.translation = TranslationKey.from(this);
        }
        if (includeBranch) {
            return this.translation.append(this.branch);
        }
        return this.translation;
    }

    private void deserialize(HoconConfigurationLoader loader) {
        if (this.resolver != null) {
            this.resolver.run();
            this.resolver = null;
        }
        if (this.isEmpty()) {
            return;
        }
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            if (!root.isNull()) {
                this.apply(root);
            }
        }
        catch (ConfigurateException e) {
            logger.error("Failed to load config", (Throwable)e);
        }
    }

    public final void deserialize(Callable<BufferedReader> source) {
        this.deserialize(Config.createLoader(builder -> builder.source(source)));
    }

    public final void load() {
        this.deserialize(this.loader);
        this.save();
    }

    private void serialize(HoconConfigurationLoader loader) {
        if (this.resolver != null) {
            throw new IllegalStateException("Cannot serialize config before it was loaded");
        }
        if (this.isEmpty()) {
            return;
        }
        CommentedConfigurationNode root = (CommentedConfigurationNode)loader.createNode();
        this.fetch(root);
        try {
            loader.save(root);
        }
        catch (ConfigurateException e) {
            logger.error("Failed to serialize config", (Throwable)e);
        }
    }

    public final void serialize(Callable<BufferedWriter> sink) {
        this.serialize(Config.createLoader(builder -> builder.sink(sink)));
    }

    public final void save() {
        this.serialize(this.loader);
    }

    protected void onChildUpdate() {
    }

    @Override
    Config getRoot() {
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modId = this.getModId();
        String other$modId = other.getModId();
        if (this$modId == null ? other$modId != null : !this$modId.equals(other$modId)) {
            return false;
        }
        return Arrays.deepEquals(this.getBranch(), other.getBranch());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modId = this.getModId();
        result = result * 59 + ($modId == null ? 43 : $modId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBranch());
        return result;
    }

    public String toString() {
        return "Config(modId=" + this.getModId() + ", branch=" + Arrays.deepToString(this.getBranch()) + ")";
    }

    public String getModId() {
        return this.modId;
    }

    public String[] getBranch() {
        return this.branch;
    }
}

