/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.util.ReflectionUtils;

public final class EntryOrigin {
    private final Config root;
    private final Parent parent;
    private final Field field;
    private final Type type;
    private final ConfigContainer container;

    EntryOrigin(Config root, Parent parent, Field field, ConfigContainer container) {
        this.root = root;
        this.parent = parent;
        this.field = field;
        this.type = ReflectionUtils.getFieldType(field);
        this.container = container;
    }

    public Object getObject() {
        return Modifier.isStatic(this.field.getModifiers()) ? null : this.container;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = this.field.getDeclaredAnnotation(annotationType);
        if (annotation == null) {
            throw new IllegalStateException("Missing required transformation annotation: " + annotationType);
        }
        return annotation;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.field.isAnnotationPresent(annotationType);
    }

    public <A extends Annotation> Optional<A> getOptionalAnnotation(Class<A> annotationType) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(annotationType));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntryOrigin)) {
            return false;
        }
        EntryOrigin other = (EntryOrigin)o;
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Object this$$getObject = this.getObject();
        Object other$$getObject = other.getObject();
        return !(this$$getObject == null ? other$$getObject != null : !this$$getObject.equals(other$$getObject));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        Object $$getObject = this.getObject();
        result = result * 59 + ($$getObject == null ? 43 : $$getObject.hashCode());
        return result;
    }

    Config getRoot() {
        return this.root;
    }

    Parent getParent() {
        return this.parent;
    }

    public Field getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }
}

