/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.objectmapping;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.Types;

final class RecordFieldDiscoverer
implements FieldDiscoverer<Object[]> {
    static final RecordFieldDiscoverer INSTANCE = new RecordFieldDiscoverer();

    private RecordFieldDiscoverer() {
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<@Nullable Object[]> discover(AnnotatedType target, FieldDiscoverer.FieldCollector<@Nullable Object[], V> collector) throws SerializationException {
        Class<?> clazz = GenericTypeReflector.erase(target.getType());
        if (!clazz.isRecord()) {
            return null;
        }
        try {
            RecordComponent[] recordComponents = clazz.getRecordComponents();
            Class[] constructorParams = new Class[recordComponents.length];
            int i = 0;
            int recordComponentsLength = recordComponents.length;
            while (i < recordComponentsLength) {
                RecordComponent component = recordComponents[i];
                Method accessor = component.getAccessor();
                accessor.setAccessible(true);
                String name = component.getName();
                AnnotatedType genericType = component.getAnnotatedType();
                constructorParams[i] = GenericTypeReflector.erase(genericType.getType());
                Field backingField = clazz.getDeclaredField(name);
                backingField.setAccessible(true);
                AnnotatedType resolvedType = GenericTypeReflector.resolveExactType(genericType, target);
                AnnotatedElement annotationContainer = Types.combinedAnnotations(component, backingField, accessor);
                int targetIdx = i++;
                collector.accept(name, resolvedType, annotationContainer, (intermediate, el, implicitSupplier) -> {
                    intermediate[targetIdx] = el != null ? el : implicitSupplier.get();
                }, x$0 -> accessor.invoke(x$0, new Object[0]));
            }
            Constructor<?> clazzConstructor = clazz.getDeclaredConstructor(constructorParams);
            clazzConstructor.setAccessible(true);
            return new FieldDiscoverer.InstanceFactory<Object[]>(this, recordComponents, constructorParams, clazzConstructor, target){

                @Override
                public Object[] begin() {
                    return new Object[recordComponents.length];
                }

                @Override
                public Object complete(@Nullable Object[] intermediate) throws SerializationException {
                    int length = intermediate.length;
                    for (int i = 0; i < length; ++i) {
                        if (intermediate[i] != null || !constructorParams[i].isPrimitive()) continue;
                        intermediate[i] = Types.defaultValue(constructorParams[i]);
                    }
                    try {
                        return clazzConstructor.newInstance(intermediate);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new SerializationException(target.getType(), (Throwable)e);
                    }
                }

                @Override
                public boolean canCreateInstances() {
                    return true;
                }
            };
        }
        catch (NoSuchFieldException | NoSuchMethodException ex) {
            throw new SerializationException(target.getType(), "Record class did not have fields and accessors aligning specification", (Throwable)ex);
        }
    }
}

