/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.EnumConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import questsadditions.events.EventTypes;
import questsadditions.tasks.BreakTask;
import questsadditions.tasks.DayTask;
import questsadditions.tasks.InteractionTask;
import questsadditions.tasks.KillNbtTask;
import questsadditions.tasks.PlaceTask;
import questsadditions.tasks.PlayerNbtTask;
import questsadditions.tasks.StructureTask;
import questsadditions.tasks.TimeTask;
import questsadditions.tasks.UseTask;

public class TasksRegistry {
    private List<BreakTask> breakTasks = null;
    private List<UseTask> useTasks = null;
    private List<PlaceTask> placeTasks = null;
    private List<StructureTask> structureTasks = null;
    private List<InteractionTask> interactionTasks = null;
    public static final TaskType BREAK = TaskTypes.register((class_2960)new class_2960("questsadditions", "break"), BreakTask::new, () -> Icon.getIcon((String)"minecraft:block/stone").combineWith(Icon.getIcon((String)"minecraft:item/diamond_pickaxe")));
    public static final TaskType PLACE = TaskTypes.register((class_2960)new class_2960("questsadditions", "place"), PlaceTask::new, () -> Icon.getIcon((String)"minecraft:block/stone"));
    public static final TaskType USE = TaskTypes.register((class_2960)new class_2960("questsadditions", "use"), UseTask::new, () -> Icon.getIcon((String)"minecraft:item/flint_and_steel"));
    public static final TaskType KILLNBT = TaskTypes.register((class_2960)new class_2960("questsadditions", "killnbt"), KillNbtTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond_sword"));
    public static final TaskType INTERACTION = TaskTypes.register((class_2960)new class_2960("questsadditions", "interaction"), InteractionTask::new, () -> Icon.getIcon((String)"minecraft:item/emerald"));
    public static final TaskType PLAYERNBT = TaskTypes.register((class_2960)new class_2960("questsadditions", "playernbt"), PlayerNbtTask::new, () -> Icons.FRIENDS);
    public static final TaskType STRUCTURE = TaskTypes.register((class_2960)new class_2960("questsadditions", "structure"), StructureTask::new, () -> Icons.ART);
    public static final TaskType TIME = TaskTypes.register((class_2960)new class_2960("questsadditions", "time"), TimeTask::new, () -> Icons.TIME);
    public static final TaskType DAYS = TaskTypes.register((class_2960)new class_2960("questsadditions", "days"), DayTask::new, () -> Icon.getIcon((String)"minecraft:item/clock_00"));
    private static TasksRegistry INSTANCE = null;
    public static final Event<EventTypes.Place> REPLACE = EventFactory.createEventResult((Object[])new EventTypes.Place[0]);
    public static final Event<EventTypes.Use> USE_EVENT = EventFactory.createEventResult((Object[])new EventTypes.Use[0]);

    private TasksRegistry() {
    }

    public void init() {
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        BlockEvent.BREAK.register(this::breakBlock);
        REPLACE.register(this::placeBlock);
        USE_EVENT.register(this::useBlock);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
    }

    public static TasksRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TasksRegistry();
        }
        return INSTANCE;
    }

    public List<StructureTask> getStructureTasks() {
        if (this.structureTasks == null) {
            this.structureTasks = ServerQuestFile.INSTANCE.collect(StructureTask.class);
        }
        return this.structureTasks;
    }

    private void fileCacheClear(QuestFile file) {
        if (file.isServerSide()) {
            this.breakTasks = null;
            this.useTasks = null;
            this.placeTasks = null;
            this.structureTasks = null;
            this.interactionTasks = null;
        }
    }

    private EventResult interactEntity(class_1657 player, class_1297 entity, class_1268 hand) {
        if (player instanceof class_3222) {
            if (this.interactionTasks == null) {
                this.interactionTasks = ServerQuestFile.INSTANCE.collect(InteractionTask.class);
            }
            if (this.interactionTasks.isEmpty()) {
                return EventResult.pass();
            }
            TeamData data = ServerQuestFile.INSTANCE.getData((class_1297)player);
            for (InteractionTask task : this.interactionTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
                task.Interact(data, entity, player.method_6047());
            }
        }
        return EventResult.pass();
    }

    private EventResult breakBlock(class_1937 world, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        if (this.breakTasks == null) {
            this.breakTasks = ServerQuestFile.INSTANCE.collect(BreakTask.class);
        }
        if (this.breakTasks.isEmpty()) {
            return EventResult.pass();
        }
        TeamData data = ServerQuestFile.INSTANCE.getData((class_1297)player);
        for (BreakTask task : this.breakTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
            task.Break(data, state.method_26204(), player.method_6047());
        }
        return EventResult.pass();
    }

    private class_1269 useBlock(class_3222 player, class_1937 world, class_1799 stack, class_2680 state, boolean useItem) {
        if (player instanceof class_3222 && !PlayerHooks.isFake((class_1657)player)) {
            if (this.useTasks == null) {
                this.useTasks = ServerQuestFile.INSTANCE.collect(UseTask.class);
            }
            if (this.useTasks.isEmpty()) {
                return class_1269.field_5811;
            }
            TeamData data = ServerQuestFile.INSTANCE.getData((class_1297)player);
            for (UseTask task : this.useTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
                task.Use(data, state.method_26204(), useItem, stack);
            }
        }
        return class_1269.field_5811;
    }

    private class_1269 placeBlock(class_1937 world, class_2338 pos, class_2680 Old, class_2680 New, @Nullable class_1297 entity) {
        if (entity instanceof class_3222 && !PlayerHooks.isFake((class_1657)((class_1657)entity))) {
            if (this.placeTasks == null) {
                this.placeTasks = ServerQuestFile.INSTANCE.collect(PlaceTask.class);
            }
            if (this.placeTasks.isEmpty()) {
                return class_1269.field_5811;
            }
            TeamData data = ServerQuestFile.INSTANCE.getData(entity);
            for (PlaceTask task : this.placeTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
                task.Place(data, Old.method_26204(), New.method_26204());
            }
        }
        return class_1269.field_5811;
    }

    public static <E> EnumConfig<E> addEnum(ConfigGroup group, String id, E value, Consumer<E> setter, NameMap<E> nameMap, E def) {
        return (EnumConfig)group.add(id, (ConfigValue)new EnumConfig<E>(nameMap){

            public void addInfo(TooltipList list) {
                list.add(1.info((String)"Default", (Object)this.getStringForGUI(this.defaultValue)));
            }
        }, value, setter, def);
    }
}

