/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.formats.glyph.GlyphVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.ExtendedQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.class_4608;

public class EntityVertexBufferWriterNio
extends VertexBufferWriterNio
implements QuadVertexSink,
GlyphVertexSink {
    private static final int STRIDE = IrisVertexFormats.ENTITY.method_1362();
    private final QuadViewEntity.QuadViewEntityNio quad = new QuadViewEntity.QuadViewEntityNio();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;
    private float uSum;
    private float vSum;

    public EntityVertexBufferWriterNio(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)ExtendedQuadVertexType.INSTANCE);
    }

    public void writeQuad(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3, int n4) {
        int n5 = this.writeOffset;
        ByteBuffer byteBuffer = this.byteBuffer;
        ++this.vertexCount;
        this.uSum += f4;
        this.vSum += f5;
        byteBuffer.putFloat(n5, f);
        byteBuffer.putFloat(n5 + 4, f2);
        byteBuffer.putFloat(n5 + 8, f3);
        byteBuffer.putInt(n5 + 12, n);
        byteBuffer.putFloat(n5 + 16, f4);
        byteBuffer.putFloat(n5 + 20, f5);
        byteBuffer.putInt(n5 + 24, n3);
        byteBuffer.putInt(n5 + 28, n2);
        byteBuffer.putShort(n5 + 36, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity());
        byteBuffer.putShort(n5 + 38, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity());
        byteBuffer.putShort(n5 + 40, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem());
        if (this.vertexCount == 4) {
            this.endQuad(n4);
        }
        this.advance();
    }

    public void writeGlyph(float f, float f2, float f3, int n, float f4, float f5, int n2) {
        this.writeQuad(f, f2, f3, n, f4, f5, n2, class_4608.field_21444, 0);
    }

    private void endQuad(int n) {
        float f;
        float f2;
        float f3;
        this.vertexCount = 0;
        int n2 = this.writeOffset;
        ByteBuffer byteBuffer = this.byteBuffer;
        this.uSum = (float)((double)this.uSum * 0.25);
        this.vSum = (float)((double)this.vSum * 0.25);
        this.quad.setup(byteBuffer, n2, STRIDE);
        if (n == 0) {
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            f3 = this.saveNormal.x;
            f2 = this.saveNormal.y;
            f = this.saveNormal.z;
            n = NormI8.pack(f3, f2, f, 0.0f);
        } else {
            f3 = Norm3b.unpackX((int)n);
            f2 = Norm3b.unpackY((int)n);
            f = Norm3b.unpackZ((int)n);
        }
        int n3 = NormalHelper.computeTangent(f3, f2, f, this.quad);
        for (int i = 0; i < 4; ++i) {
            byteBuffer.putFloat(n2 + 42 - STRIDE * i, this.uSum);
            byteBuffer.putFloat(n2 + 46 - STRIDE * i, this.vSum);
            byteBuffer.putInt(n2 + 32 - STRIDE * i, n);
            byteBuffer.putInt(n2 + 50 - STRIDE * i, n3);
        }
        this.uSum = 0.0f;
        this.vSum = 0.0f;
    }
}

