/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.google.common.collect.ImmutableList;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.BaseOptionElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.StringOption;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuStringOptionElement;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class StringElementWidget
extends BaseOptionElementWidget<OptionMenuStringOptionElement> {
    protected final StringOption option;
    protected String appliedValue;
    protected int valueCount;
    protected int valueIndex;
    protected class_5250 prefix;
    protected class_5250 suffix;

    public StringElementWidget(OptionMenuStringOptionElement optionMenuStringOptionElement) {
        super(optionMenuStringOptionElement);
        this.option = optionMenuStringOptionElement.option;
    }

    @Override
    public void init(ShaderPackScreen shaderPackScreen, NavigationController navigationController) {
        super.init(shaderPackScreen, navigationController);
        String string = ((OptionMenuStringOptionElement)this.element).getPendingOptionValues().getStringValueOrDefault(this.option.getName());
        this.appliedValue = ((OptionMenuStringOptionElement)this.element).getAppliedOptionValues().getStringValueOrDefault(this.option.getName());
        this.prefix = new class_2585(class_2477.method_10517().method_4678("prefix." + this.option.getName()) ? class_2477.method_10517().method_4679("prefix." + this.option.getName()) : "");
        this.suffix = new class_2585(class_2477.method_10517().method_4678("suffix." + this.option.getName()) ? class_2477.method_10517().method_4679("suffix." + this.option.getName()) : "");
        this.setLabel(GuiUtil.translateOrDefault((class_5250)new class_2585(this.option.getName()), "option." + this.option.getName(), new Object[0]));
        ImmutableList<String> immutableList = this.option.getAllowedValues();
        this.valueCount = immutableList.size();
        this.valueIndex = immutableList.indexOf(string);
    }

    @Override
    public void render(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
        this.updateRenderParams(n3, 0);
        this.renderOptionWithValue(class_45872, n, n2, n3, n4, bl);
        this.tryRenderTooltip(class_45872, n5, n6, bl);
    }

    private void increment(int n) {
        this.valueIndex = Math.max(this.valueIndex, 0);
        this.valueIndex = Math.floorMod(this.valueIndex + n, this.valueCount);
    }

    @Override
    protected class_2561 createValueLabel() {
        return this.prefix.method_27661().method_10852((class_2561)GuiUtil.translateOrDefault((class_5250)new class_2585(this.getValue()), "value." + this.option.getName() + "." + this.getValue(), new Object[0])).method_10852((class_2561)this.suffix).method_27694(class_25832 -> class_25832.method_27703(class_5251.method_27717((int)0x6688FF)));
    }

    @Override
    public String getCommentKey() {
        return "option." + this.option.getName() + ".comment";
    }

    public String getValue() {
        if (this.valueIndex < 0) {
            return this.appliedValue;
        }
        return (String)this.option.getAllowedValues().get(this.valueIndex);
    }

    protected void queue() {
        Iris.getShaderPackOptionQueue().put(this.option.getName(), this.getValue());
    }

    @Override
    public boolean applyNextValue() {
        this.increment(1);
        this.queue();
        return true;
    }

    @Override
    public boolean applyPreviousValue() {
        this.increment(-1);
        this.queue();
        return true;
    }

    @Override
    public boolean applyOriginalValue() {
        this.valueIndex = this.option.getAllowedValues().indexOf((Object)this.option.getDefaultValue());
        this.queue();
        return true;
    }

    @Override
    public boolean isValueModified() {
        return !this.appliedValue.equals(this.getValue());
    }
}

